// MediaConverter.h
//
//   A demo program that converts audio or video files to a different format.
//   Source files can be in any file format for which there is an installed
//   extractor and decoder.  Destination files can be any file format for which
//   there is a writer and audio/video encoders.  For example, MediaConverter
//   can convert a Quicktime movie with Cinepak encoded video and IMA4 audio
//   to an AVI file with Indeo5 encoded video and raw audio on a standard
//   BeOS R4.5 installation because there proper encoders and decoders are
//   installed by default.
//
//   Copyright 1999, Be Incorporated.   All Rights Reserved.
//   This file may be used under the terms of the Be Sample Code License.

#include <Be.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/param.h> // for MAX() macro
#include <inttypes.h>

#if B_BEOS_VERSION>=0x520
	typedef const char Char; 
	#if B_BEOS_VERSION>=0x530 // 0x530 RC3
		#include <locale/Locale.h>
		#define OS "Zeta RC3"
	#else
		#include <Locale.h>
		#define OS "Zeta RC2"
	#endif
#else 
	#define _T(str) str 
	typedef char Char; 
	#define OS "BeOS R5"
#endif

#ifndef MEDIACONVERTER_H
#define MEDIACONVERTER_H

#define VERSION "Version 1.3.0"

// Mr. Beer makes Zeta / R5 compatible header 
// http://www.wht.mmtr.or.jp/~hirotsu/zeta.html

//

class BMediaFile;
class BMenuField;
struct media_codec_info;
struct media_file_format;
//
	class BMediaWindow;
	BTextControl *textcontrol1;
	BTextControl *textcontrol2;
	BTextControl *textcontrol3;
	BStringView *fOutputFolder;
	BString start_time; 
	BString end_time; 
	BFilePanel  *fFilePanel;
	BFilePanel  *fFilePanelS;
    BMenu		*aMenu;
    BMenu		*bMenu;
    BMenuBar	*MenuBar;
   	BSlider		*VideoQuality_Slider;
   	BSlider		*AudioQuality_Slider;
//

class MediaFileInfoView : public BView
{
public:
				MediaFileInfoView(BRect frame, uint32 resizingMode);
	virtual		~MediaFileInfoView();

	void		Update(BMediaFile *f, entry_ref *ref);
	void		GetFileInfo(BString *audioFormat, BString *videoFormat,
							BString *audioDetails, BString *videoDetails,
							BString *duration);
protected:

	virtual void Draw(BRect update);
	virtual void AttachedToWindow();

private:
	entry_ref	fRef;
	BMediaFile*	fMediaFile;
};

class MediaFileListView : public BListView
{
public:
				MediaFileListView(BRect frame, uint32 resizingMode);
	virtual		~MediaFileListView();

	void		AddItem(BMediaFile *f, entry_ref *ref);

	void		SetEnabled(bool enabled);
	bool		IsEnabled();

protected:

	virtual void KeyDown(const char *bytes, int32 numBytes);
	virtual void SelectionChanged();

private:
	bool		fEnabled;
};


class StatusView : public BView
{
public:
					StatusView(BRect frame, uint32 resizingMode);
	virtual			~StatusView();

	void			SetStatus(const char *text);
	const char*		Status();

protected:

	virtual void	AttachedToWindow();
	virtual void	Draw(BRect update);
	virtual void	MessageReceived(BMessage *msg);

private:
	BRect		fStatusRect;
	BString		fStatusString;
};

class MediaConverterWindow : public BWindow
{
public:
	void		CreateMenu();
	void		SetLabel();
	void		DestroyMenu();
	void		LanguageChanged();
				MediaConverterWindow(BRect frame);
	virtual		~MediaConverterWindow();

	void		BuildFormatMenu();
	void		BuildAudioVideoMenus();
	void		GetSelectedFormatInfo(media_file_format **format,
									 media_codec_info **audio,
									 media_codec_info **video);
	
	void		SetStatusMessage(const char *message);
	void		SetFileMessage(const char *message);
	
	void		AddSourceFile(BMediaFile *f, entry_ref *ref);
	void		RemoveSourceFile(int32 index);
	int32		CountSourceFiles();
	status_t	GetSourceFileAt(int32 index, BMediaFile **f, entry_ref *ref);

	void		SourceFileSelectionChanged();

	void		SetEnabled(bool enabled, bool buttonEnabled);
	bool		IsEnabled();
	
protected:
//	virtual void	DispatchMessage(BMessage *msg, BHandler *handler);
	virtual void	MessageReceived(BMessage *msg);
	virtual bool	QuitRequested();

private:
	media_format	fDummyFormat;
	BButton		*fConvertButton;
//
	BButton		*fDestButton;
	BButton		*fPreviewButton;
	BBox *box1;
	BBox *box2;
	BBox *box3;
//
	BMenuField	*fFormatMenu;
	BMenuField	*fVideoMenu;
	BMenuField	*fAudioMenu;
	StatusView	*fStatusView;
	StatusView	*fStatusView2;
	MediaFileListView	*fListView;
	MediaFileInfoView	*fInfoView;
 
	bool	fEnabled;
	bool	fConverting;
	bool	fCancelling;
};

class MediaConverterApp : public BApplication
{
public:
				MediaConverterApp();
	virtual		~MediaConverterApp();

	BEntry	CreateOutputFile(BMediaFile *input, entry_ref *ref,
								 media_file_format *outputFormat);
	
	bool		IsConverting();
	void		StartConverting();
	void		ConvertLoop();
	status_t	ConvertFile(BMediaFile *inFile, BMediaFile *outFile,
							media_codec_info *audioCodec,
							media_codec_info *videoCodec, bigtime_t StartTime, bigtime_t EndTime);

	void		SetStatusMessage(const char *message);

protected:
	virtual void	MessageReceived(BMessage *msg);
	virtual void	ReadyToRun();
	virtual void	RefsReceived(BMessage *msg);
	
private:
	static int32	RunConvert(void *castToMediaConverterApp);
	
	MediaConverterWindow *fWin;
	thread_id	fConvertThreadID;
	bool	fConverting;
	bool	fCancel;
};

const char APP_SIGNATURE[]			= "application/x-vnd.Be.MediaConverter";
#define SOURCE_BOX_LABEL			_T("Source files")
#define INFO_BOX_LABEL				_T("File details")
#define OUTPUT_BOX_LABEL			_T("Output format")
#define FORMAT_LABEL 				_T("File format")
#define VIDEO_LABEL		 			_T("Video encoding")
#define AUDIO_LABEL 				_T("Audio encoding")
//
#define OUTPUT_FOLDER_LABEL			_T("Output Folder")
#define PREVIEW_BUTTON_LABEL		_T("Preview")
#define START_LABEL 				_T("Start mSec ")
#define END_LABEL 					_T("End   mSec ")
//
#define FORMAT_MENU_LABEL			_T("Format")
#define VIDEO_MENU_LABEL 			_T("Video")
#define AUDIO_MENU_LABEL 			_T("Audio")
#define DURATION_LABEL				_T("Duration:")
#define VIDEO_INFO_LABEL			_T("Video:")
#define AUDIO_INFO_LABEL			_T("Audio:")
#define CONVERT_LABEL				_T("Convert")
#define CANCEL_LABEL				_T("Cancel")
#define VIDEO_QUALITY_LABEL			_T("Video quality %3d%%")
#define AUDIO_QUALITY_LABEL			_T("Audio quality %3d%%")
#define SLIDER_LOW_LABEL			_T("Low")
#define SLIDER_HIGH_LABEL			_T("High")
#define NONE_LABEL					_T("None available")
#define DROP_MEDIA_FILE_LABEL		_T("Drop media files onto this window")
#define CANCELING_LABEL				_T("Cancelling...")
#define ABOUT_TITLE_LABEL			_T("About...")
#define OK_LABEL					_T("OK")
#define CANCELLING_LABEL			_T("Cancelling...")
#define CONV_COMPLETE_LABEL			_T("Conversion completed")
#define CONV_CANCEL_LABEL			_T("Conversion cancelled")
#define CANCELLING_LABEL			_T("Cancelling...")
#define SELECT_DIR_LABEL			_T("Select This Directory")
#define SELECT_LABEL				_T("Select")
#define SAVE_DIR_LABEL				_T("MediaConverter+:SaveDirectory")
#define NO_FILE_LABEL				_T("No file selected")
//
#define FILE_MENU_LABEL				_T("File")
#define OPEN_MENU_LABEL				_T("Open...")
#define ABOUT_MENU_LABEL			_T("About...")
#define QUIT_MENU_LABEL				_T("Quit")
#define PRIORITY_MENU_LABEL			_T("Priority")

#define PRIORITY_LOW				_T("1:Low")
#define PRIORITY_NORMAL				_T("2:Normal") 
#define PRIORITY_HIGH				_T("3:High")
#define PRIORITY_TOP				_T("4:Top")

#define WRITE_AUDIO_STRING			_T("Writing audio track:")
#define WRITE_VIDEO_STRING			_T("Writing video track:")
#define COMPLETE_STRING				_T("complete")
#define OUTPUT_FILE_STRING1			_T("Output file")
#define OUTPUT_FILE_STRING2			_T("created")
#define AUDIO_SUPPORT_STRING		_T("Audio-Quality doesn't support")
#define VIDEO_SUPPORT_STRING		_T("Video-Quality doesn't support")
#define VIDEO_PARAMFORM_STRING		_T("Video-Using Parameter Form Settings")
#define CONTINUE_STRING				_T("Continue")
#define FILES						_T("files")
#define FILE						_T("file")
#define NOTRECOGNIZE				_T(" were not recognized as supported media files:")
//
#define LAUNCH_ERROR				_T("Error launching: ")
#define OUTPUT_FILE_STRING3			_T("Error creating")
#define CONVERT_ERROR_STRING		_T("Error converting")
#define ERROR_WRITE_VIDEO_STRING	_T("Error writing video frame ")
#define ERROR_WRITE_AUDIO_STRING	_T("Error writing audio frame ")
#define ERROR_READ_VIDEO_STRING		_T("Error read video frame ") 
#define ERROR_READ_AUDIO_STRING		_T("Error read audio frame ")
#define ERROR_LOAD_STRING			_T("Error loading file")

const uint32 CONVERT_BUTTON_MESSAGE		= 'cVTB';
const uint32 FORMAT_SELECT_MESSAGE		= 'fMTS';
const uint32 AUDIO_CODEC_SELECT_MESSAGE	= 'aCSL';
const uint32 VIDEO_CODEC_SELECT_MESSAGE	= 'vCSL';
const uint32 FILE_LIST_CHANGE_MESSAGE	= 'fLCH';
const uint32 START_CONVERSION_MESSAGE	= 'stCV';
const uint32 CANCEL_CONVERSION_MESSAGE	= 'cNCV';
const uint32 CONVERSION_DONE_MESSAGE	= 'cVSD';
//
const uint32 OUTPUT_FOLDER_MESSAGE		= 'oUTF';
const uint32 FOLDER_SELECT_MESSAGE		= 'sLFO';
const uint32 OPEN_FILE_MESSAGE		    = 'oFIL';
const uint32 DISP_ABOUT_MESSAGE		    = 'aBUT';
const uint32 QUIT_MESSAGE			    = 'qUIT';
const uint32 PREVIEW_MESSAGE			= 'pVEW';
const uint32 PRIORITY_CHANGED_MESSAGE	= 'cPRI';
const uint32 VIDEO_QUALITY_CHANGED_MESSAGE	= 'vQCG';
const uint32 AUDIO_QUALITY_CHANGED_MESSAGE	= 'aQCG';
const uint32 SELECT_THIS_DIR_MESSAGE	= 'sDir';
//
#endif //MEDIACONVERTER_H
