/*
	
	NtWindow.cpp
	
	La fenetre Unique de notre NetWork Time Client
	(c) 1997 Tsk aka Hirlimann Ludovic
	
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 */



#include <Application.h>
#include "NtWindow.h"
#include "ntpmagic.h"

void set_palette_entry(long i,rgb_color c);
/* Construit la fenetre de telle manière qu'icelle ne soit pas
	modifiable par l'utilisateur.
	ATTENTION : Si la fonte par défaut n'est pas la bonne
*/
NtWindow::NtWindow(BRect frame, NtView *view)
				: BWindow(frame, "NetWork Time", B_TITLED_WINDOW,
				 B_NOT_RESIZABLE+B_NOT_ZOOMABLE)										
{
	ntview = view;
	aret=NULL;
	AddShortcut('A', B_COMMAND_KEY | B_SHIFT_KEY, new BMessage(B_ABOUT_REQUESTED));
}


/* Maintenant on initialise les differents objets present dans notre
 fenetre */
void	NtWindow::Init(char *fetch)
{
	BRect	carre=Bounds();
	Lock();
	//carre.PrintToStream();
	
	/* Manque de bol SetTarget ne s'applique pas aux BMenuBar
	*/
	// lemenu->SetTarget(be_app); et merde ....
	
	/* Bon maintenant on initialise le BTextControl où
	l'adresse du serveur ntp est stocké
	*/

	carre.top=5;
	carre.left += 5;
	carre.right -= 5;
	carre.bottom = 6;
	
	serveur = new BTextControl(carre,"saisie","Server Address:",fetch,NULL,
					B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP,	B_NAVIGABLE | B_WILL_DRAW);

	serveur->SetDivider(be_plain_font->StringWidth("Server Address: "));
	//serveur->SetDivider(120.0);
	//serveur->ResizeToPreferred();
	serveur->Show();
	ntview->AddChild(serveur);
	/* Maintenant il s'agit d'ajouter la barre de progression */
	// attention au rectangle
	//mprogression= new BStatusBar(BRect(10,168,130,194),NULL);
	
	carre = serveur->Frame();
	carre.OffsetTo(carre.left, carre.bottom + 10);
	
	mprogression= new BStatusBar(carre,NULL, "Ready");
	mprogression->SetViewColor(230,230,230);
	mprogression->SetLowColor(230,230,230);
	ntview->AddChild(mprogression);

	carre = mprogression->Frame();
	carre.OffsetTo(carre.left, carre.bottom + carre.Height() + 10);
	/* Utiliser Bounds pour mettre un bouton qui ait de la Gueule*/
	
	mettrealheure = new BButton(carre,"mettre à lheure",
						"Update Time",new BMessage(ACTION_MESSAGE));
	mettrealheure->MakeDefault(true);
	mettrealheure->ResizeToPreferred();
	mettrealheure->MoveTo((carre.right - mettrealheure->Bounds().right) * .5, carre.top);
	
	ResizeTo(Bounds().right, mettrealheure->Frame().bottom + 5);
	ntview->ResizeTo(Bounds().right + 2, Bounds().bottom + 2);
//	/* Ainsi c'est l'application qui s'occupe de la gestion réseau
//	*/
	mettrealheure->SetTarget(be_app);
//	/* Maintenant je veux que appuyer sur enter active le bouton
//	*/
	// Ajoute le bouton à la hierachie active ...
	ntview->AddChild(mettrealheure);
	/* Mettre les menus, avec les SetTarget(be_app) pour que ce soit
	l'application qui réponde aux interactions du Menu */

	Unlock();

		
}
bool NtWindow::QuitRequested()
{
	// on transmet à l'application comme la fenètre est seule
	// pas de problème
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(TRUE);
}

/* Bon là il fallait juste que ce soit l'application qui
gèrent le réseau, comme ça on demande pas deux fois l'heure
au meme moment ....
*/
void NtWindow::MessageReceived(BMessage *message)
{
	switch (message->what)
	{
		case SAVE_PREFS:// sauvegarde des preferences
			be_app->PostMessage(SAVE_PREFS);
			break;
		//case ACTION_MESSAGE:// Il sera jamais reçu Ici ....
							// sauf si je met un menu ...
		//	be_app->PostMessage(ACTION_MESSAGE);
		//	break;
		case B_ABOUT_REQUESTED:
			be_app->PostMessage(B_ABOUT_REQUESTED);
		default :
			BWindow :: MessageReceived(message);
			break;
	}
}
void NtWindow::Reset(void)
{
	Lock();
	mprogression->Reset(NULL,NULL);
	Unlock();
}
void NtWindow::Progres(float maj)
{
	Lock();
	mprogression->Update(maj,NULL,NULL);
	Unlock();
}
void NtWindow::Gauche(char *txt)
{
	Lock();
	mprogression->SetText(txt);
	Unlock();
}
void NtWindow::Droite(char *txt)
{
	Lock();	
	mprogression->SetTrailingText(txt);
	Unlock();
}
