#  Copyright 1999 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.
#
#  Password prompt.  Totally hoky.
#
import string

from BApplication import BApplication
from BBox import BBox
from BMenuItem import BMenuItem
from BMenu import BMenu
from BMessage import BMessage
from BView import BView
from BWindow import BWindow

from AppKit import B_QUIT_REQUESTED, B_KEY_DOWN

from InterfaceKit import B_PLAIN_BORDER,B_FANCY_BORDER,B_BACKSPACE,B_ENTER,B_SPACE,B_TAB,B_ESCAPE,B_SUBSTITUTE,B_LEFT_ARROW,B_RIGHT_ARROW,B_UP_ARROW,B_DOWN_ARROW,B_INSERT,B_DELETE,B_HOME,B_END,B_PAGE_UP,B_PAGE_DOWN,B_SHIFT_KEY,B_COMMAND_KEY,B_CONTROL_KEY,B_CAPS_LOCK,B_SCROLL_LOCK,B_NUM_LOCK,B_OPTION_KEY,B_MENU_KEY,B_WILL_DRAW,B_NAVIGABLE,B_TITLED_WINDOW,B_NOT_RESIZABLE,B_NOT_ZOOMABLE,B_FOLLOW_ALL

from core import core

class XView(BView):
	drawcolor = (210, 210, 210, 0)
	slecolor = (120, 210, 120, 0)
	nocolor = (255, 255, 255, 0)
	def __init__(self, rect, win):
		BView.__init__(self, rect, 'blind', B_FOLLOW_ALL, B_WILL_DRAW)
		self.text = []
		self.insertpoint = 0
		self.height = rect[3] - rect[1]
		self.width = rect[2] - rect[0]
		self.win = win
	def Draw(self, rect):
		for i in range(len(self.text) + 1):
			self.drawCell(i)
	def drawCell(self, i):
		xo = i * 12.0 + 4.0
		yo = 3.0

		if i == self.insertpoint:
			background = self.slecolor
		else:
			background = self.nocolor
		self.SetHighColor(background)
		self.FillRect((xo, 2.0, xo + 12.0, self.height - 2.0))

		if i < len(self.text):
			self.SetHighColor(self.drawcolor)
			self.FillRoundRect((xo, yo, xo + 8.0, yo + 12.0),
				4.0, 6.0)

	def insert(self, ic):
		self.text.insert(self.insertpoint, ic)
		self.insertpoint = self.insertpoint + 1
		self.drawCell(self.insertpoint - 1)
		self.drawCell(self.insertpoint)
		e = len(self.text) - 1
		if self.insertpoint < e:
			self.drawCell(e)
	def mv(self, inc):
		was = self.insertpoint
		self.insertpoint = self.insertpoint + inc
		if self.insertpoint < 0:
			self.insertpoint = 0
		elif self.insertpoint > len(self.text):
			self.insertpoint = len(self.text)
		nowis = self.insertpoint
		if was != nowis:
			self.drawCell(was)
			self.drawCell(nowis)
	def erase(self, inc):
		i = self.insertpoint
		self.mv(inc)
		if self.insertpoint != i:
			del self.text[self.insertpoint:i]
			self.drawCell(len(self.text))
	def KeyDown(self, k, kl):
		if ord(k) >= ord(' '):
			self.insert(k)
		elif ord(k) == B_ENTER:
			self.win.text = self.text
			self.win.PostMessage(B_QUIT_REQUESTED)
		elif ord(k) == B_BACKSPACE:
			self.erase(-1)
		elif ord(k) == B_LEFT_ARROW:
			self.mv(-1)
		elif ord(k) == B_RIGHT_ARROW:
			self.mv(1)
		elif k == '\025':
			self.mv(100000)
			self.erase(-100000)
		elif k == '\002':
			self.mv(-1)
		elif k == '\006':
			self.mv(1)
		elif k == '\008':
			self.erase(-1)
		elif k == '\004':
			self.erase(1)
		elif k == '\005':
			self.mv(100000)
		elif k == '\001':
			self.mv(-100000)

class BlindWindow(BWindow):
	def __init__(self, frame, prompt, initial, semaphore):
		BWindow.__init__(self, frame, self.__class__.__name__,
			B_TITLED_WINDOW, B_NOT_ZOOMABLE)
		# set up a rectangle and instantiate a new view
		r, t, l, b = self.Bounds()
		self.top = BBox((r, t, l, b), 'top', B_FOLLOW_ALL,
			B_WILL_DRAW|B_NAVIGABLE, B_PLAIN_BORDER)
		self.text = None
		self.semaphore = semaphore
		self.view = XView((r + 12, t + 8, l - 12, b - 8), self)
		self.top.AddChild(self.view)
        	self.AddChild(self.top);
		self.view.MakeFocus(1)
	def QuitRequested(self):
		if self.text is None:
			text = None
		else:
			text = string.join(self.text, '')
		core.setswitch(self.semaphore, text)
		return 1

class MainFn(BApplication):
	def __init__(self):
		core.register('blind_prompt', self)
	def blind_prompt(self, prompt, initial, semaphore):
		window = BlindWindow((100.0, 80.0, 450.0, 110.0), prompt, initial, semaphore)
		window.Show()
