#  Copyright 1999 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.
#
#  Read rc file containing Python expressions.
#
import os
import sys
import traceback
import types

class Config:
	def __init__(self, name = '(no name)'):
		self.name = name

top = Config('(top)')

class Account(Config):
	#  An Account instance defaults its attributes from the "top"
	#  Config instance.  So I can define a parameter at either the
	#  top level, or in the current Account, and access it through
	#  the account either way.
	def __getattr__(self, attr):
		return getattr(top, attr)

def complain(tag, err):
	print '%s:' % (tag,),
	for e in err:
		print e,
	print

def evaluate(file):
	cfl = []

	#  Read whole file, and try to run the data as Python source.

	fc = ''
	try:
		fp = open(file, 'r')
		while 1:
			z = fp.read(8192)
			if not z:
				break
			fc = fc + z
	except IOError, val:
		complain(file, str(val))
		return cfl
	fp.close()
	try:
		#  Aside from basic builtins, need the Account class in
		#  the namespace of the config statements.
		d = {'Account': Account}
		exec(fc, d)
	except:
		tp, vl, tb = sys.exc_info()
		complain(file, traceback.format_exception_only(tp, vl))
		return cfl

	#  Go through the namespace and pick up the results.
	for k, v in d.items():
		#  Ignore anything with leading underscore.
		if k[:1] != '_':
			if isinstance(v, Account):
				#  cfl is a list of configuration namespaces,
				#  top + accounts.  If this is a new account,
				#  add it to the list.  If it's an old account,
				#  just make note of the name.  I'm not sure
				#  this code is really right, by the way.
				names = getattr(v, '_names', None)
				if names is None:
					names = []
					cfl.append(v)
				names.append(k)
				v._names = names
			elif v is Account:
				#  Ignore the Account class.
				pass
			else:
				#  "top level" attribute, not per class.
				top.__dict__[k] = v
	return cfl

def saveframe(name, frame):
	#  I think it might be better to save window size & location in
	#  a separate file.
	if not hasattr(top, 'Frames'):
		top.Frames = {}
	top.Frames[name] = frame
	save()

def getframe(name):
	if hasattr(top, 'Frames'):
		return top.Frames.get(name)
	else:
		return None

rc = '/boot/home/config/settings/pynr/rc'
cflist = []
def init():
	global cflist
	global cf
	global rc
	cfl = evaluate(rc)
	for cf in cfl:
		cflist.append(cf)
	if len(cflist) == 0:
		cf = Account('(none)')
	elif len(cflist) >= 1:
		cf = cflist[0]
		for cfd in cflist[1:]:
			if 'default' in cfd._names:
				cf = cfd
				break

def setdefault(name):
	global cflist
	global cf
	for x in cflist:
		if x.name == name:
			cf = x
			break

def save():
	global rc
	tmp = rc + '.tmp'
	fp = open(tmp, 'w')
	fp.write('# %s\n' % rc)
	fp.write('# Python syntax, OK to edit while application not running.\n')
	fp.write('\n')
	for cf in cflist:
		inst = cf._names[0]
		fp.write('%s = Account(\'%s\')\n' % (inst, cf.name))
		for alt in cf._names[1:]:
			fp.write('%s = %s\n' % (alt, inst))
		for k, v in cf.__dict__.items():
			if k[:1] == '_' or k == 'name':
				pass
			elif type(v) == types.ListType and len(v) > 1:
				fp.write('%s.%s = [\n' % (inst, k))
				for i in v:
					fp.write('%s,\n' % repr(i))
				fp.write(']\n')
			else:
				fp.write('%s.%s = %s\n' % (inst, k, repr(v)))
	for k, v in top.__dict__.items():
		if k[:1] == '_':
			pass
		fp.write('%s = %s\n' % (k, repr(v)))
	fp.close()
	os.rename(tmp, rc)

if __name__ == '__main__':
	global cf
	global cflist
	if len(sys.argv) > 1:
		global rc
		rc = sys.argv[1]
	init()
	print top.__dict__
	for c in cflist:
		print c.__dict__
	save()
