#  Copyright 2000 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.

from BMessage import BMessage
import kernel

class Core:
	QMSG = 75
	def __init__(self):
		self.chalk = {}
		self.queue = {}
		self.switches = {}
		self.k = 0
		self.gate = kernel.create_sem(1, 'core-gate')
	def __call__(self, fn, *av):
		kernel.acquire_sem(self.gate)
		mq = self.chalk.get(fn)
		kernel.release_sem(self.gate)
		if mq is None or not mq.qzmessenger.IsValid():
			print fn, 'call failed,', mq, 'not valid.'
		else:
			mq.qzenqueue(fn, av)
	def register(self, fn, mq):
		kernel.acquire_sem(self.gate)
		self.chalk[fn] = mq
		kernel.release_sem(self.gate)
	def target(self, fn):
		kernel.acquire_sem(self.gate)
		mq = self.chalk[fn]
		kernel.release_sem(self.gate)
		return mq.qzmessenger

	#  set/takeswitch is a way to block for a return value.
	def setswitch(self, sem, ret):
		kernel.acquire_sem(self.gate)
		self.switches[sem] = ret
		kernel.release_sem(self.gate)
		kernel.release_sem(sem)
	def takeswitch(self, sem):
		kernel.acquire_sem(sem)
		kernel.acquire_sem(self.gate)
		ret = self.switches[sem]
		del self.switches[sem]
		kernel.release_sem(self.gate)
		return ret

core = Core()
