#  Copyright 1999 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.
#
#  Traceback Alert when Looper thread crashes via Python exception.
#
import BApplication
from BAlert import BAlert
import string
import traceback

class LastChanceLooper:
	def lastchance(self, et, ev, tb):
		el = traceback.format_exception(et, ev, tb)
		st = string.join(el, '')[:-1]
		a = BAlert('Python exception', st, 'This Python application has raised the above fatal exception, exit at your convenience', None, None, 2, 4)
		a.Go()
