#  Copyright 1999 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.

import string
import tempfile

import support

import configure
from core import core
from listwin import MenuScrollWindow, TabItem
from notewin import NoteWindow
# import mimify
from newsnote import NewsNote
from nsrv import NNTP
from queue import exportii
from BApplication import BApplication

from AppKit import B_QUIT_REQUESTED

class Group:
	width = (300.0, 60.0)
	def __init__(self, cf, group):
		self.name, self.seen = group
		self.cf = cf
		self.countstr = ''
		self.value = (self.name, '')
	def __str__(self):
		return self.name
	def count_unseen(self, first, last):
		# --- Could count all unseen, but that's not the
		#     right thing to report.  Lots of old junk may be
		#     missing on the server, in its low..high range,
		#     but the interesting number is recent unseen.
		#     That might be IDs above the last seen, or it
		#     could include some fudge range to account for
		#     reasonable latency.  Or you could work from
		#     an inventory of the group rather than range.
		# 
		if self.seen:
			c = 0
			for i in range(len(self.seen) - 1, -1, -1):
				f, l = self.seen[i]
				if l < first:
					c = c + last - first
					break
				else:
					c = c + last - l
					if f <= first or l - f > 10:
						break
					else:
						last = f - 1
		else:
			c = last - first
		self.recount(c)
	def recount(self, c):
		self.countstr = '%d' % c
		self.value = (self.name, self.countstr)
	def saw(self, first, last):
		#  Note "seen" range, meaning message list has been
		#  displayed including these messages.
		for i in range(len(self.seen)):
			fi, li = self.seen[i]
			if first == li + 1:
				self.seen[i] = (fi, last)
				break
			elif last < fi:
				self.seen.insert(i, (first, last))
				break
		else:
			self.seen.append((first, last))
	def unseen(self, first, last):
		#  Report unseen messages from range.
		u = [(first, last)]
		for f, l in self.seen:
			y = []
			for first, last in u:
				if l >= first and f <= last:
					if f > first:
						y.append((first, f - 1))
					if l < last:
						y.append((l + 1, last))
				else:
					y.append((first, last))
			u = y
		# if limit:
		# 	t = []
		# 	for first, last in u:
		# 		limit = limit - (last - first + 1)
		# 		if limit < 0:
		# 			first = first - limit
		# 		t.insert(0, (first, last))
		# 		if limit <= 0:
		# 			break
		# 	u = t
		return u


#
#  List of USENET groups.
#

class GroupList(MenuScrollWindow):
	wzmenus = [('Message', [('View', 'visit', (), 0), ('View 50', 'visit50', (), 0)])]
	def __init__(self, cf, service):
		self.service = service
		self.cf = cf
		self.list = self.initialselection()

		#  wzinit (graphics) starts the groups window thread, so
		#  the rest of this function is thread-external.
		self.wzinit(self.name, self.list)
		#  Fire off a bunch of group requests, to get statuses
		#  for new message counts.
		for i in range(len(self.list)):
			self.service.changeGroup(self, self.list[i])
	def initialselection(self):
		list = []
		self.name = '%s news groups' % self.cf.name
		try:
			groups = self.cf.groups
		except:
			groups = ()
		self.groupmap = {}
		for group in groups:
			group = Group(self.cf, group)
			self.groupmap[group.name] = len(list)
			list.append(group)
		return list
	def mzvisit(self, k, limit):
		#  User selected a group
		g = self.list[k]
		core('open_newsgroup', g, limit)
		self.wzdamage(k)
	def iisetgroup(self, name, first, last, count):
		index = self.groupmap[name]
		g = self.list[index]
		g.count_unseen(first, last)
		self.wzdamage(index)
	def exit(self):
		core('close_newsgroup_host', self.cf)
	exec(exportii(locals()))

class ArticleList(MenuScrollWindow):
	menus = [('Message', [('View', 'visit', None)])]
	def __init__(self, group, service):
		self.list = []
		self.group = group
		self.name = group.name
		self.limit = None
		self.service = service
		self.wzinit(self.name, None)
		self.Show()
	def setlimit(self, limit):
		self.limit = limit
	def fail(self):
		self.wzfail('No articles')
	def mzvisit(self, k, limit):
		art = self.list[k]
		core('open_news', self.group, art)
	def iisetgroup(self, name, first, last, count):
		#  NNTP server provides count along with first-last.
		#  Seems redundant, empirically too.  I get 423 Bad
		#  article with old messages, but count is no help.

		if self.limit:
			if last - first > self.limit:
				unseen = [(last - self.limit + 1, last)]
			else:
				unseen = [(first, last)]
		else:
			unseen = self.group.unseen(first, last)
		if unseen:
			self.service.getXhdrs(self, self.group, unseen,
					NewsNote.htags)
		else:
			self.fail()
	def iixhdrs(self, rv):
		if rv:
			for i in range(len(rv)):
				rv[i] = (string.atoi(rv[i][0]), rv[i][1])
			rv.sort()
			fs = rv[0][0]
			ls = fs
		sawl = []
		for num, fields in rv:
			if ls and num > ls + 1:
				sawl.append((fs, ls))
				fs = num
			ls = num
			msg = NewsNote()
			id = '%s' % num
			# fields = map(lambda x: support.convert_to_utf8(0, mimify.mime_decode_header(x)), fields)
			msg.fromscan(id, fields)
			self.list.append(msg)
		if rv:
			sawl.append((fs, ls))
		self.list = thread(self.list)
		self.wzupdate(self.list)
		for fs, ls in sawl:
			self.group.saw(fs, ls)
		configure.save()
	def exit(self):
		core('close_newsgroup', self.group)
	exec(exportii(locals()))

def thread(list):
	dir = {}
	if not list:
		return list
	tl = []
	for m in list:
		r = filter(lambda x: x != '(none)', string.split(m.hd['References']))
		r.append(m.hd['Message-ID'])
		for k in r:
			t = dir.get(k)
			if t:
				break
		else:
			t = []
			tl.append((0, t))
		t.append((string.atoi(m.id), m))
		for k in r:
			dir[k] = t
	for i in range(len(tl)):
		n, t = tl[i]
		t.sort()
		num, m = t[0]
		tl[i] = (num, t)
	tl.sort()
	list = []
	for w0, t in tl:
		for w1, m in t:
			list.append(m)
	return list

class Service:
	def __init__(self):
		self.srv = {}
	def server(self, cf):
		srv = self.srv.get(cf.name)
		if srv is None:
			srv = NNTP(cf)
			self.srv[cf.name] = srv
		return srv
	def close(self, cf):
		srv = self.srv.get(cf.name)
		if srv:
			srv.quit()
			del self.srv[cf.name]

class Host:
	def __init__(self):
		self.win = None
		self.fwin = {}

class MainFn(BApplication):
	news = Service()
	def __init__(self):
		core.register('open_newsgroup_host', self)
		core.register('close_newsgroup_host', self)
		core.register('open_newsgroup', self)
		core.register('close_newsgroup', self)
		core.register('open_news', self)
		core.register('post_news', self)
		self.news_hosts = {}
	def getgroup(self, group):
		host = self.news_hosts.get(group.cf.name)
		if host is None:
			return None, None
		else:
			fwin = host.fwin.get(group.name)
			if fwin and not fwin.qzmessenger.IsValid():
				fwin = None
				self.delgroup(group)
			return fwin, host
	def setgroup(self, group, win):
		host = self.news_hosts.get(group.cf.name)
		host.fwin[group.name] = win
	def delgroup(self, group):
		host = self.news_hosts.get(group.cf.name)
		if host:
			try:
				del host.fwin[group.name]
			except KeyError:
				pass
			if not host.win and not host.fwin:
				del self.news_hosts[group.cf.name]
				self.news.close(group.cf)
	def open_newsgroup_host(self):
		cf = configure.cf
		h = self.news_hosts.get(cf.name)
		if h is None:
			h = Host()
		if h.win is None:
			h.win = GroupList(cf, self.news.server(cf))
		self.news_hosts[cf.name] = h
	def close_newsgroup_host(self, cf):
		h = self.news_hosts.get(cf.name)
		if h:
			h.win = None
		if not h or not h.fwin:
			self.news.close(cf)
	def open_newsgroup(self, group, limit):
		fwin, host = self.getgroup(group)
		if not fwin:
			srv = self.news.server(group.cf)
			fwin = ArticleList(group, srv)
			if limit:
				fwin.setlimit(limit)
			self.setgroup(group, fwin)
			srv.changeGroup(fwin, group)
			if not limit:
				group.recount(0)
	def close_newsgroup(self, group):
		self.delgroup(group)
	def open_news(self, group, art):
		win = NoteWindow('%s:%s' % (group.name, art.id), art)
		win.run()
		if art.actual:
			win.damage()
		else:
			self.news.server(group.cf).getArticle(win, group, art.id)
	def post_news(self, win, file):
		self.news.server(configure.cf).postArticle(win, file)
