#  Copyright 1999 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.
#
#     Message display window.
#
import os
import re
import string
import sys
import time

from BBox import BBox
# from BButton import BButton
from BDirectory import BDirectory
from BEntry import BEntry
from BFilePanel import BFilePanel
from BMenu import BMenu
from BMenuBar import BMenuBar
from BMenuItem import BMenuItem
from BMessage import BMessage
from BMessenger import BMessenger
from BScrollView import BScrollView
from BStringView import BStringView
from BTextView import BTextView
from BWindow import BWindow
from BLooper import BLooper
from BAlert import BAlert
import kernel


import configure
from core import core
from errpt import LastChanceLooper
from queue import CallQueue, exportii

from AppKit import B_QUIT_REQUESTED,B_SAVE_REQUESTED,B_CANCEL
from InterfaceKit import B_FANCY_BORDER,B_NO_BORDER,B_PLAIN_BORDER,B_FOLLOW_ALL,B_FOLLOW_LEFT,B_FOLLOW_RIGHT,B_FOLLOW_TOP,B_WILL_DRAW,B_NAVIGABLE_JUMP,B_FRAME_EVENTS,B_NAVIGABLE,B_V_SCROLL_BAR_WIDTH,B_H_SCROLL_BAR_HEIGHT,B_NOT_RESIZABLE,B_NOT_ZOOMABLE,B_TITLED_WINDOW,B_FONT_ALL
from StorageKit import B_FILE_NODE,B_OPEN_PANEL,B_SAVE_PANEL

class EditThread(BLooper):
	def __init__(self, note, caller):
		self.note = note
		editor = getattr(configure.cf, 'editor', None)
		if editor is None or editor == 'vi' or editor == 'vim':
			self.cmd = ('/boot/beos/apps/Terminal', '-t', caller.name, '/boot/beos/bin/vim', '-n', note.filename)
		elif editor == 'StyledEdit':
			self.cmd = ('/boot/apps/StyledEdit', note.filename)
		elif type(editor) == type(''):
			self.cmd = (editor, note.filename)
		else:
			self.cmd = editor + (note.filename,)
		self.caller = caller
		BLooper.__init__(self, 'text edit')
		self.Run()
		self.PostMessage(1)
		self.PostMessage(B_QUIT_REQUESTED)
	def MessageReceived(self, msg):
		term = kernel.load_image(self.cmd, os.environ)
		kernel.wait_for_thread(term)
		self.caller.editdamage()

class Offset:
	def __init__(self, x, y):
		self.init = (x, y)
		self.cur = self.init
	def use(self):
		l, t = self.cur
		if l > 100.0 or t > 100.0:
			self.cur = self.init
		else:
			self.cur = (l + 10.0, t + 10.0)
		return (l, t)

class TextWin(CallQueue, BWindow):
	savedir = '/boot/home'
	w = 400.0
	hb = 200.0
	hh = 56.0
	xm = 8.0
	ym = 8.0
	ys = 8.0
	off = Offset(40.0, 34.0)
	def __init__(self, name, data):
		# print self.__class__.__name__, 'begin __init__', sys.getrefcount(self)
		self.name = name
		self.data = data
		self.mkwin()
		# print self.__class__.__name__, 'after mkwin', sys.getrefcount(self)
		self.mkviews()
		# print self.__class__.__name__, 'end __init__', sys.getrefcount(self)
	def mkwin(self):
		l, t = self.off.use()
		ww, wh = self.dimensions()
		# print self.__class__.__name__, 'before wrap', sys.getrefcount(self)
		BWindow.__init__(self, (l, t, ww + l, wh + t), self.name,
			B_TITLED_WINDOW, B_NOT_ZOOMABLE)
		# print self.__class__.__name__, 'after wrap', sys.getrefcount(self)
	def run(self):
		self.Show()
		self.qzinit(BWindow)
	def mkviews(self):
		# ww, wh = (400.0, 400.0)
		# l = 18.0
		# t = 18.0
		l0, t0, ww, wh = self.Bounds()
		bx = BBox((0.0, 0.0, ww, wh), 'box', B_FOLLOW_ALL,
			B_WILL_DRAW|B_FRAME_EVENTS|B_NAVIGABLE_JUMP,
			B_PLAIN_BORDER)
		self.bar = BMenuBar((0.0, 0.0, ww, wh), 'Bar')
		self.menus()
		ww = ww - B_V_SCROLL_BAR_WIDTH
		wh = wh - B_H_SCROLL_BAR_HEIGHT
		tx = BTextView((4.0, 24.0, ww - 4.0, wh - 24.0), 'text',
			(0.0, 0.0, ww - 28.0, 28.0), B_FOLLOW_ALL, B_WILL_DRAW)
		tx.SetText(self.data)
		sx = BScrollView('ScrollView', tx, B_FOLLOW_ALL, 0, 0,
				1, B_FANCY_BORDER)
		bx.AddChild(self.bar)
		bx.AddChild(sx)
		self.AddChild(bx)
	def MessageReceived(self, msg):
		#  For menu items.
		if msg.what == B_SAVE_REQUESTED:
			name = msg.FindString('name')
			dir = msg.FindRef('directory')
			self.savetofile(name, dir)
		elif msg.what == B_CANCEL:
			pass
		else:
			CallQueue.MessageReceived(self, msg)
	def savedlg(self):
		ref = BEntry(self.savedir).GetRef()
		msg = BMessage(B_SAVE_REQUESTED)
		self.filepanel = BFilePanel(B_SAVE_PANEL,
			self.qzmessenger, ref, B_FILE_NODE, 0, msg)
		name = self.savename()
		if name:
			self.filepanel.SetSaveText(name)
		self.filepanel.Show()
	def savename(self):
		return None
	def menus(self):
                self.filemenu = BMenu('File')
		msg = self.qzsetfnmsg('savedlg', ())
                self.filemenu.AddItem(BMenuItem('Save', msg, 'S'))
                self.filemenu.AddItem(BMenuItem('Close',
			BMessage(B_QUIT_REQUESTED), 'W'))
		self.bar.AddItem(self.filemenu)
	def savetofile(self, name, dir):
		d = BDirectory(dir)
		e = BEntry(d, name, 1)
		p = e.GetPath()
		file = p.Path()
		if hasattr(self.data, 'savetofile'):
			#  Note class
			self.data.savetofile(file)
		else:
			#  String
			fp = open(file, 'w')
			fp.write(self.data)
			fp.close()
	def dimensions(self):
		ww = 2 * self.xm + self.w
		wh = 2 * self.ym + self.hh + self.hb
		return (ww, wh)
	def QuitRequested(self):
		# print self.__class__.__name__, 'QuitRequested', sys.getrefcount(self)
		if hasattr(self.data, 'close'):
			self.data.close()
		return 1
	def __del__(self):
		print self.__class__.__name__, '__del__'

class FTextView(BTextView):
	spp = ' \t\r\n,(){}\[\]\'"`'
	sppexp = re.compile('[' + spp + ']')
	httpexp = re.compile('https?:[^' + spp + ']*')
	def __init__(self, frame, title, bounds):
		BTextView.__init__(self, frame, title, bounds, B_FOLLOW_ALL,
			B_WILL_DRAW)
		self.SetStylable(1)
		self.MakeEditable(0)
		self.ut = []
		self.text = ''
		self.foundword = None
	def SetText(self, text):
		ut = []
		i = 0
		exp = self.httpexp
		while 1:
			h = exp.search(text, i)
			if h is None:
				break
			s, e = h.span()
			if text[e - 1] == '.':
				e = e - 1
			ut.append((s, e))
			i = e + 1
		self.text = text
		BTextView.SetText(self, text)
		from BFont import be_plain_font
		for s, e in ut:
			self.SetFontAndColor(s, e, be_plain_font, B_FONT_ALL, (0, 0, 255, 0))
		self.ut = ut
	def browse(self, url):
		#  wait_for_thread() works for some releases, but e.g.,
		#  PPC BeOS 5 NetPositive will hang the window if we wait
		#  for it.
		browser = kernel.load_image(('/boot/beos/apps/NetPositive', url),
				os.environ)
		kernel.resume_thread(browser)
	def FindWord(self, offset):
		#  Empirically, this function comes in pairs.  That messes
		#  up the URL call, runs browser twice.  So, save return
		#  and the second time, just return it again.
		if self.foundword:
			fw = self.foundword
			self.foundword = None
			return fw
		for s, e in self.ut:
			if offset > s and offset < e:
				url = self.text[s:e]
				self.browse(url)
				self.foundword = (s, e)
				return s, e
		text = self.text
		if offset > len(self.text):
			offset = len(self.text) - 1
			self.foundword = (offset, offset)
			return offset, offset
		if text[offset] in self.spp:
			self.foundword = (offset, offset)
			return offset, offset
		i = offset - 1
		while i >= 0 and not text[i] in self.spp:
			i = i - 1
		x = self.sppexp.search(text, offset)
		if x is None:
			j = len(text)
		else:
			j = x.start()
		self.foundword = (i + 1, j)
		return i + 1, j

class TwoTextWin(TextWin):
	hm = 20.0
	def run(self):
		self.Show()
		self.qzinit(BWindow)
	def mkviews(self):
		ww, wh = self.dimensions()
		self.box = BBox((0.0, 0.0, ww, wh), 'box', B_FOLLOW_ALL,
			B_WILL_DRAW|B_FRAME_EVENTS|B_NAVIGABLE_JUMP,
			B_PLAIN_BORDER)
                self.bar = BMenuBar((0.0, 0.0, ww, wh), 'Bar')
		self.menus()
		ww = self.w - B_V_SCROLL_BAR_WIDTH
		wh = self.hh - B_H_SCROLL_BAR_HEIGHT
		hh = self.ym + self.hm
		self.head = BTextView((self.xm, hh, self.xm + ww,
			wh + hh), 'Headers', (0.0, 0.0, ww, wh),
			B_FOLLOW_ALL, B_WILL_DRAW)
		self.hdscr = BScrollView('ScrollView', self.head,
			B_FOLLOW_LEFT|B_FOLLOW_TOP|B_FOLLOW_RIGHT, 0, 0, 1,
			B_FANCY_BORDER)
		ww = self.w - B_V_SCROLL_BAR_WIDTH
		wh = self.hb - B_H_SCROLL_BAR_HEIGHT
		yoff = self.hm + self.ym + self.hh + self.ys
		# self.body = BTextView((self.xm, yoff, self.xm + ww,
		# 		yoff + wh),
		# 	'Headers', (0.0, 0.0, ww, wh), B_FOLLOW_ALL,
		# 	B_WILL_DRAW)
		self.body = FTextView((self.xm, yoff, self.xm + ww,
				yoff + wh),
			'Headers', (0.0, 0.0, ww, wh))
		self.bdscr = BScrollView('ScrollView', self.body,
			B_FOLLOW_ALL, 0, 0, 1, B_PLAIN_BORDER)
		self.box.AddChild(self.bar)
		self.box.AddChild(self.hdscr)
		self.box.AddChild(self.bdscr)
		self.AddChild(self.box)
	def dimensions(self):
		ww = 2 * self.xm + self.w
		wh = 2 * self.ym + self.hh + self.hb + self.hm
		return (ww, wh)
	def setattachments(self, parts):
		pass
	def menus(self):
                self.filemenu = BMenu('File')
                self.filemenu.AddItem(BMenuItem('Close',
			BMessage(B_QUIT_REQUESTED), 'W'))
		self.bar.AddItem(self.filemenu)

class NoteWindow(LastChanceLooper, TwoTextWin):
	savedir = '/boot/home/mail'
	replyfile = ['/tmp/repart%s', 0]
	def save(self):
		#  to do - get edited headers here
		self.data.rewrite(self.body.Text())
	def savename(self):
		return self.data.savename()
	def iifail(self, status):
		self.head.SetText(
			'Article could not be retrieved:\n  "%s"' % status)
	def reply(self):
		if not self.data.actual:
			return
		rep = self.data.makereply(self.replyfile[0] % self.replyfile[1])
		self.replyfile[1] = self.replyfile[1] + 1
		win = ReplyNoteWindow('%s reply' % self.name, rep)
		win.run()
		win.damage()
	def edit(self):
		self.spud = EditThread(self.data, self)
	def iieditdamage(self):
		self.data.fromfile()
		self.iidamage()
		self.xedit = 1
	def iidamage(self):
		text = ''
		for key in self.data.stdheaders:
			val = self.data.getheader(key)
			if val:
				text = text + '%s: %s\n' % (key, val)
		self.head.SetText(text)
		# XXX - not necessarily reading the whole thing!
		#       who has time to read all this garbage anyway.
		msgs = self.data.contents()
		self.body.SetText(msgs[0].body())
		if len(msgs) > 1:
			self.setattachments(msgs[1:])
		self.body.MakeFocus(1)
		#  Why doesn't this work?  Text shows up fine, but
		#  window handler stops getting menuitem control messages.
		# b = self.data.BFile
		# off = self.data.rfc822.startofbody
		# bsz = b.GetStat()[6] - off
		# self.body.SetText(b, int(off), int(bsz))
		self.xedit = 0
	def iimessage(self, list):
		self.data.fromstrings(list)
		self.iidamage()
	def showpart(self, i):
		part = self.parts[i - 1]
		if not part.show():
			w = TextWin('Attachment %s' % i, part.body())
			w.run()
	def showheader(self):
		w = TextWin('Header', str(self.data.rfc822))
		w.run()
	def setattachments(self, parts):
		if parts and not hasattr(self, 'attachmenu'):
			self.parts = parts
			self.attachmenu = BMenu('Attachments')
			# self.attachmenu.SetHighColor((0, 255, 0, 0))
			for i in range(len(parts)):
				msg = self.qzsetfnmsg('showpart', (i + 1,))
				m = BMenuItem('Attachment %d' % (i + 1), msg, chr(ord('1') + 1))
				self.attachmenu.AddItem(m)
			self.bar.AddItem(self.attachmenu)
	def menus(self):
                self.filemenu = BMenu('File')
		msg = self.qzsetfnmsg('showheader', ())
                self.filemenu.AddItem(BMenuItem('Header', msg, 'H'))
		msg = self.qzsetfnmsg('savedlg', ())
                self.filemenu.AddItem(BMenuItem('Save', msg, 'S'))
		msg = self.qzsetfnmsg('reply', ())
                self.filemenu.AddItem(BMenuItem('Reply', msg, 'R'))
                self.filemenu.AddItem(BMenuItem('Close',
			BMessage(B_QUIT_REQUESTED), 'W'))
		self.bar.AddItem(self.filemenu)
	exec(exportii(locals()))


class ReplyNoteWindow(NoteWindow):
	def menus(self):
                self.filemenu = BMenu('File')
		if self.data.getheader('newsgroups'):
			msg = self.qzsetfnmsg('post', ())
                	self.filemenu.AddItem(BMenuItem('Post (USENET)', msg))
		msg = self.qzsetfnmsg('mail', ())
                self.filemenu.AddItem(BMenuItem('Reply (SMTP)', msg))
		msg = self.qzsetfnmsg('edit', ())
                self.filemenu.AddItem(BMenuItem('Edit', msg, 'E'))
                self.filemenu.AddItem(BMenuItem('Close',
			BMessage(B_QUIT_REQUESTED), 'W'))
		self.bar.AddItem(self.filemenu)
		self.quit_ok = 1
	def ok_to_quit(self, maybe):
		self.quit_ok = maybe
	def QuitRequested(self):
		return self.quit_ok
	def mail(self):
		if not self.xedit:
			self.save()
		self.data.mail()
	def post(self):
		if not self.xedit:
			self.save()
		self.quit_ok = 0
		core('post_news', self, self.data.filename)
	def iiposted(self, status, text):
		if not status:
			self.ok_to_quit(1)
	exec(exportii(locals()))
