#  Copyright 1999 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.
#
#  Adapted from newsfetch.py in tknf, Copyright 1995 - Koert Zeilstra 

import nntplib
import posixpath
import socket
import string
import os
import sys

from BLooper import BLooper

from core import core
from queue import exportii, CallQueue

class NNTP(CallQueue, BLooper):
	error = Exception
	def __init__(self, cf):
		BLooper.__init__(self, cf.name)
		self.service = None
		self.server = None
		self.failing = 0
		self.cf = cf
		self.name = '%s NNTP' % self.cf.name
		self.report(7, 'No connection yet')
		self.ready = 0
		self.currentGroup = None
		self.groupStatus = 0
		self.Run()
		self.qzinit(BLooper)

	def report(self, stv, sts):
		core('report', self.name, stv, sts)

	def splitLine(self, line):
		i = string.find(line, ' ')
		if i >= 0:
			field1 = line[:i]
			field2 = line[i+1:]
		else:
			field1 = ''
			field2 = ''
		return field1, field2

	def reconnect(self, fun, arg):
		if self.failing:
			raise
		self.failing = 1
		self.ready = 0
		self.service = None
		self.currentGroup = ''
		ret = apply(fun, arg)
		self.failing = 0

	def _select(self, group):
		if not self.ready:
			if not self.iiconnect():
				return
		if self.currentGroup == group.name:
			return
		self.currentGroup = ''
		self.report(5, 'visiting group %s' % group.name)
		try:
			status, count, first, last, groupname = self.service.group(group.name)
		except socket.error, val:
			self.report(9, 'retrying on %s' % val)
			return self.reconnect(self._select, (group,))
		self.groupStatus = (groupname, string.atoi(count),
			string.atoi(first), string.atoi(last))
		self.currentGroup = group.name
		self.report(0, '%s: %s' % (self.currentGroup, self.groupStatus))

	def iichangeGroup(self, thr, group):
		self._select(group)
		group, count, first, last = self.groupStatus
		thr.setgroup(group, first, last, count)

	def iiconnect(self):
		if self.service is None:
			if self.server is None:
				self.server = self.cf.nntpserver
			self.report(6, 'Connecting to %s' % self.server)
			if type(self.server) == type(''):
					self.server = (self.server,)
			try:
				self.service = apply(nntplib.NNTP, self.server)
			except socket.error, err:
				self.report(9, '%s: %s' % (self.server, err.args[1]))
				return 0
		self.ready = 1
		return 1

	def iigetArticle(self, thr, group, number):
		self._select(group)
		self.report(5, 'getting article on %s' % number)
		try:
			status, nr, id, list = self.service.article(number)
#1.5		except nntplib.error_temp, val:
#			status = str(val)
#1.6
		except nntplib.NNTPError, val:
			status = val.response
			nr = '00'
			id = '00'
			list = ()
		except socket.error:
			return self.reconnect(self.iigetArticle, (thr, group, number))
		if list:
			self.report(0, '%s, %s, %s: %d lines' % (status, nr, id, len(list)))
		else:
			self.report(7, '%s: %s' % (number, status))
			if status[:3] == '423':
				list = ('', status)
			else:
				raise self.error(status)
		thr.message(list)

	def iigetGroupList(self, thr):
		self.report(5, 'group list')
		if not self.ready:
			if not self.iiconnect():
				return
		result = self.service.list()
		self.report(0, '%d groups' % len(result[1]))
		thr.grouplist(result[1])

	def iigetXhdrs(self, thr, group, unseen, fields):
		self._select(group)
		self.report(5, 'getting Xhdr')
		dict = {}
		for start, end in unseen:
			rng = '%d-%d' % (start, end)
			for i in range(len(fields)):
				try:
					status, values = self.service.xhdr(fields[i], rng)
				except socket.error, val:
					return self.reconnect(self.iigetXhdrs, (thr, group, unseen, fields))
				if i == 0:
					for k, v in values:
						f = ['']*len(fields)
						f[0] = v
						dict[k] = f
				else:
					for k, v in values:
						f = dict.get(k)
						if f:
							f[i] = v
		self.report(0, '%d fields' % len(fields))
		thr.xhdrs(dict.items())

	def iipostArticle(self, thr, filename):
		if not self.ready:
			if not self.iiconnect():
				return
		fp = open(filename, 'r')
		self.report(5, 'posting article')
		try:
			line = self.service.post(fp)
		except socket.error, val:
			return self.reconnect(self.iipostArticle, (thr, filename))

		self.report(0, line)
		fp.close()
		status, msg = self.splitLine(line)
		status = string.atoi(status)
		if status >= 400:
			thr.posted(status, msg)
		else:
			thr.posted(None, None)

	def quit(self):
		if self.service:
			self.report(5, 'quit')
			try:
				self.service.quit()
			except socket.error, val:
				self.report(5, 'OK, already dead anyway!')
			self.service = None
		# self.ready = 0
		self.Quit()

	exec(exportii(locals()))
