#  Copyright 2000 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.

import pickle
import string

from BMessage import BMessage
from BMessenger import BMessenger
from semaphore import Semaphore
from BLooper import BLooper
from BWindow import BWindow

#  To be called at end of class block, and the output exec'd.
#  Tried to make a lambda work here instead, no joy.
def exportii(env):
	stmt = []
	for nm in env.keys():
		if nm[:2] == 'ii':
			fn = nm[2:]
			stmt.append('def %s(self, *av): self.qzenqueue("%s", av)' % (fn, nm))
	return string.join(stmt, '\n')

class CallQueue:
	CPMSG = 74
	QZMSG = 75
	QZSUP = 76
	#  Queueing, Message controlled mixin class for functions to be called
	#  from other threads.
	def qzinit(self, loopclass):
		self.qzloopclass = loopclass
		self.qzcall_queue = []
		self.qzcall_gate = Semaphore(1)
		self.PostMessage(self.QZSUP, self)
		#  Block here until the loop starts running.
		self.Lock()
		self.qzmessenger = BMessenger(self)
		self.Unlock()
	def vqzup(self):
		pass
	def qzenqueue(self, fn, av):
		self.qzcall_gate.acquire()
		self.qzcall_queue.append((fn, av))
		self.qzcall_gate.release()
		try:
			self.qzmessenger.SendMessage(self.QZMSG)
		except:
			pass  # I apparently died.
	def qzunqueue(self):
		self.qzcall_gate.acquire()
		#  Could this get out of synch?  Message missed for some reason,
		#  and now we have one function call stuck on the stack forever?
		#  Not seeing it, but of course requests do correctly pile up,
		#  e.g. many NNTP group visit requests.
		# if len(self.qzcall_queue) > 1:
		# 	print 'call queue %s depth %d' % (self, len(self.qzcall_queue))
		fn, av = self.qzcall_queue[0]
		del self.qzcall_queue[0]
		self.qzcall_gate.release()
		apply(getattr(self, fn), av)
	def qzrequeue(self, fn, av):
		self.qzcall_gate.acquire()
		self.qzcall_queue.insert(0, (fn, av))
		self.qzcall_gate.release()
		self.qzmessenger.SendMessage(self.QZMSG)
	def callfnmsg(self, msg):
		fn = msg.FindString('fn')
		fn = getattr(self, fn)
		try:
			av = msg.FindString('av')
		except:
			av = None
		if av is None:
			fn(msg)
		else:
			av = pickle.loads(av)
			apply(fn, av)
	def qzsetfnmsg(self, fn, av = None):
		msg = BMessage(self.CPMSG)
		msg.AddString('fn', fn)
		if not av is None:
			av = pickle.dumps(av)
			msg.AddString('av', av)
		return msg
	def msgdrop(self, cl, msg):
		for w in cl.__bases__:
			if (w.__name__ == 'BWindow'
			    or w.__name__ == 'BLooper'
			    or w.__name__ == 'BApplication'):
				w.MessageReceived(self, msg)
				return 1
			else:
				if self.msgdrop(w, msg):
					return 1
		return 0
	def MessageReceived(self, msg):
		if msg.what == self.CPMSG:
			#  Message posted with function name and arguments.
			#  Could be the message from a BControl, for example.
			self.callfnmsg(msg)
		elif msg.what == self.QZMSG:
			#  Message posted with argument data in a
			#  thread interlocked common area.
			self.qzunqueue()
		elif msg.what == self.QZSUP:
			self.vqzup()
		else:
			if not self.msgdrop(self.__class__, msg):
				print >> sys.stderr,'no base target found for',\
					self.__class__.__name__,\
					self.__class__.__bases__

