#  Copyright 2000 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.

import kernel

class Semaphore:
	def __init__(self, avail):
		if avail:
			avail = 1
		else:
			avail = 0
		self.sem = kernel.create_sem(avail, 'sem%s' % id(self))
	def __del__(self):
		kernel.delete_sem(self.sem)
	def acquire(self):
		kernel.acquire_sem(self.sem)
	def release(self):
		kernel.release_sem(self.sem)
