#  Copyright 1999 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.
#
#
import string

from BBox import BBox
from BMenuItem import BMenuItem
from BMenu import BMenu
from BMessage import BMessage
from BTextControl import BTextControl
from BView import BView
from BWindow import BWindow

from AppKit import B_QUIT_REQUESTED, B_KEY_DOWN

from InterfaceKit import B_PLAIN_BORDER,B_FANCY_BORDER, B_BACKSPACE,B_ENTER,B_SPACE,B_TAB,B_ESCAPE,B_SUBSTITUTE,B_LEFT_ARROW, B_RIGHT_ARROW,B_UP_ARROW,B_DOWN_ARROW,B_INSERT,B_DELETE,B_HOME,B_END, B_PAGE_UP,B_PAGE_DOWN,B_SHIFT_KEY,B_COMMAND_KEY,B_CONTROL_KEY, B_CAPS_LOCK,B_SCROLL_LOCK,B_NUM_LOCK,B_OPTION_KEY,B_MENU_KEY,B_WILL_DRAW,B_NAVIGABLE,B_TITLED_WINDOW,B_NOT_RESIZABLE,B_NOT_ZOOMABLE,B_FOLLOW_ALL

class FPrompt(BWindow):
	def __init__(self, caller, label):
		BWindow.__init__(self, (100.0, 80.0, 460.0, 120.0),
			self.__class__.__name__,
			B_TITLED_WINDOW, B_NOT_ZOOMABLE)
		# set up a rectangle and instantiate a new view
		r, t, l, b = self.Bounds()
		self.top = BBox((r, t, l, b), 'top', B_FOLLOW_ALL,
			B_WILL_DRAW|B_NAVIGABLE, B_PLAIN_BORDER)
		msg = BMessage(9)
		self.view = BTextControl((r + 12, t + 8, l - 12, b - 8),
			'prompt', label, '', msg)
		self.top.AddChild(self.view)
        	self.AddChild(self.top);
		self.view.MakeFocus(1)
		self.caller = caller
		self.Show()
	def MessageReceived(self, msg):
		if msg.what == 9:
			msg = self.caller.qzsetfnmsg('wzfind')
			msg.AddString('pattern', self.view.Text())
			self.caller.qzmessenger.SendMessage(msg)
			self.PostMessage(B_QUIT_REQUESTED)
