#  Copyright 1999 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.
#
#     (IMAP) Mail application functions.
#
import string
import sys
import tempfile

from BAlert import BAlert
from BApplication import BApplication
from BMessage import BMessage
from BMessageRunner import BMessageRunner

import configure
from core import core
from listwin import MenuScrollWindow, TabItem
from mailcache import MailCache
from mailfolder import MailFolder
from mailnote import MailNote
from msrv import IMAP4
from notewin import NoteWindow
from queue import exportii

def infoAlert(str):
	a = BAlert('usage recommendation', str, 'OK?', None, None, 2, 1)
	a.Go()

class FTabItem(TabItem):
	tgtcolor = (210, 80, 0, 0)
	def colorpick(self, slct):
		if self.fields.targeted:
			bg = self.tgtcolor
		elif slct:
			bg = self.slecolor
		else:
			bg = self.nocolor
		return self.drawcolor, bg

class MTabItem(TabItem):
	spmcolor = (120, 120, 120, 0)
	def colorpick(self, slct):
		if slct:
			bg = self.slecolor
		else:
			bg = self.nocolor
		print self.fields.isaspam
		if self.fields.isaspam == 'yes':
			fg = self.spmcolor
		else:
			fg = self.drawcolor
		return fg, bg

#  List of folders.
#
class FolderList(MenuScrollWindow):
	wzmenus = [('Folder', [('Target', 'target', 'T', 0)])]
	wzitemdraw = FTabItem
	def __init__(self, cf, service):
		self.runner = None
		self.cf = cf
		self.service = service
		self.list = self.initialselection()
		self.targetfolderindex = None
		self.wzinit(self.title, self.list)
	def initialselection(self):
		list = []
		self.title = '%s folders' % self.cf.name
		try:
			folders = self.cf.folders
		except:
			folders = ['INBOX']
		try:
			readfolders = self.cf.readfolders
		except:
			readfolders = []
		self.foldermap = {}
		for folder in folders:
			f = MailFolder(self.cf, folder, 1)
			self.foldermap[f.name] = len(list)
			list.append(f)
		for folder in readfolders:
			f = MailFolder(self.cf, folder, 0)
			self.foldermap[f.name] = len(list)
			list.append(f)
		return list
	def mzvisit(self, k, limit):
		folder = self.list[k]
		core('open_mailfolder', folder, limit)
	def target(self, msg):
		k = self.wzselectindex
		for f in self.list:
			f.targeted = 0
		if self.targetfolderindex == k:
			self.list[k].targeted = 0
			self.targetfolderindex = None
		else:
			if not self.targetfolderindex is None:
				self.wzdamage(self.targetfolderindex)
			self.list[k].targeted = 1
			self.targetfolderindex = k
		self.wzdamage(k)
	def iiping_update(self, folder, count, recent):
		i = self.foldermap[folder.name]
		folder = self.list[i]
		folder.recount(count, recent)
		self.wzdamage(i)
		self.spam()
	def spam(self):
		if self.runner is None:
			try:
				rate = self.cf.imapcheckinterval
			except AttributeError:
				rate = 150
			list = []
			for folder in self.list:
				list.append(folder.name)
			list = string.join(list)
			msg = BMessage(self.service.PING)
			msg.AddString('folders', list)
			mr = self.service.qzmessenger
			self.runner = BMessageRunner(mr, msg, rate * 1000000, -1)
	def movemail(self, old, id):
		if self.targetfolderindex is None:
			infoAlert('Select a target folder!')
		else:
			folder = self.list[self.targetfolderindex]
			self.service.move(old, id, folder)
	def exit(self):
		self.runner = None
		core('close_mailfolder_host', self.cf)
	exec(exportii(locals()))

class MessageList(MenuScrollWindow):
	wzmenus = [('Message', [('View', 'visit', None), ('Delete', 'delete', 'D'), ('Move', 'move', 'T'), ('Undelete', 'undelete', 'U')]),
		('Folder', [('Purge', 'expunge', None)])]
	wadsize = 70
	wzitemdraw = MTabItem
	def __init__(self, folder, service):
		self.list = []
		self.startat = -1
		self.folder = folder
		self.name = folder.name
		self.count = 0
		self.hole = []
		self.service = service
		self.wzinit(self.name, None)
		self.cache = MailCache(self.folder.cf, self.folder.name)
	def initialselection(self):
		return []
	def fail(self):
		self.wzfail('No messages')
	def mzvisit(self, k, limit):
		msg = self.list[k]
		core('open_mail', self.folder, msg)
	def iiping_update(self, count, recent):
		if count > self.count:
			for i in range(self.count, count):
				m = MailNote()
				self.list.append(m)
				self.wzextend()
			if self.count == 0:
				self.wzupdate(self.list)
				self.filluid(1, count)
			else:
				self.hole.append((self.count + 1, count))
		self.count = count
		if self.hole:
			self.fill()
	def filluid(self, first, last):
		self.service.getuids(self.folder, first, last)
	def iiuids(self, folderid, rv):
		i = 0
		e = -1
		deleted = 0
		self.cache.verify(folderid)
		for idno, uid, fl in rv:
			if 'Deleted' in fl:
				deleted = 1
			if self.startat is None or i < self.startat:
				pass
			else:
				if 'Seen' in fl:
					self.startat = -1
				else:
					if self.startat < 0:
						self.startat = i
			if self.cache.findmsg(uid, idno, fl, self.list[i]):
				if i - e > 1:
					self.hole.append((e + 2, i))
				e = i
				self.wzdamage(i)
			i = i + 1
		if self.count - e > 1:
			self.hole.append((e + 2, self.count))
		if deleted > 0:
			self.wzenablemenuitem('expunge', 1)
		if self.hole:
			self.fill()
			core('pctview', None, id(self))
		else:
			if self.startat is None:
				pass
			else:
				if self.startat < 0:
					self.startat = self.count - 1
				self.wzjump(self.startat)
				self.startat = None
	def fill(self):
		first, last = self.hole[0]
		if first <= last - self.wadsize:
			self.hole[0] = (first, last - self.wadsize)
			first = last - self.wadsize + 1
		else:
			del self.hole[0]
		self.service.gethdrs(self.folder, first, last)
		# self.service.getenvelope(self.folder, first, last)
	def iienvelope(self, first, rv):
		#
		#  The IMAP envelope is a sort of Lisp-syntax list of
		#  header items, all parsed out in a fixed standard
		#  order.  It would be interesting to see if this is
		#  faster or slower than the raw header.  Haven't
		#  done the work yet, though.  It would be more
		#  interesting in a system with a parser, like the
		#  mx text parser, because a) it could easily parse
		#  the envelope, and b) I could integrate it with
		#  the rfc822 replacement.
		#
		core('pctview', (len(rv) * 100.0)/self.count, id(self))
		if self.hole:
			self.fill()
		i = first - 1
		deleted = 0
		for idno, fl, hd in rv:
			if 'Deleted' in fl:
				deleted = 1
			if self.startat is None or i < self.startat:
				pass
			else:
				if 'Seen' in fl:
					self.startat = -1
				else:
					if self.startat < 0:
						self.startat = i
			self.list[i].fromscanenv(idno, fl, hd)
			self.wzdamage(i)
			i = i + 1
		if deleted > 0:
			self.wzenablemenuitem('expunge', 1)
		if not self.hole:
			core('pctview', None, None)
			if self.startat is None:
				pass
			else:
				if self.startat < 0:
					self.startat = self.count - 1
				self.wzjump(self.startat)
				self.startat = None
	def iihdrs(self, first, rv):
		core('pctview', (len(rv) * 100.0)/self.count, id(self))
		if self.hole:
			self.fill()
		i = first - 1
		deleted = 0
		for idno, uid, fl, hd in rv:
			if 'Deleted' in fl:
				deleted = 1
			if self.startat is None or i < self.startat:
				pass
			else:
				if 'Seen' in fl:
					self.startat = -1
				else:
					if self.startat < 0:
						self.startat = i
			self.list[i].fromscan(idno, fl, hd)
			self.cache.cachemsg(uid, self.list[i])
			self.wzdamage(i)
			i = i + 1
		if deleted > 0:
			self.wzenablemenuitem('expunge', 1)
		if not self.hole:
			self.cache.dump()
			core('pctview', None, None)
			if self.startat is None:
				pass
			else:
				if self.startat < 0:
					self.startat = self.count - 1
				self.wzjump(self.startat)
				self.startat = None
	def delete(self, msg):
		item = self.list[self.wzselectindex]
		self.service.flagmessage(self.folder, item.id, 'Deleted')
		return 0
	def undelete(self, msg):
		item = self.list[self.wzselectindex]
		self.service.flagmessage(self.folder, item.id, '-Deleted')
		return 0
	def move(self, msg):
		item = self.list[self.wzselectindex]
		core('move_mail', self.folder, item.id)
	def expunge(self, msg):
		self.service.expunge(self.folder)
	def iiexpunged(self):
		self.wzenablemenuitem('expunge', 0)
	def exit(self):
		core('close_mailfolder', self.folder)
	# need exit function to checkout
	exec(exportii(locals()))

class Service:
	def __init__(self):
		self.srv = {}
	def server(self, cf):
		srv = self.srv.get(cf.name)
		if srv is None:
			srv = IMAP4(cf)
			self.srv[cf.name] = srv
		return srv
	def close(self, cf):
		srv = self.srv.get(cf.name)
		if srv:
			srv.logout()
			del self.srv[cf.name]

class Host:
	def __init__(self):
		self.win = None
		self.fwin = {}

class MainFn(BApplication):
	imap = Service()
	def __init__(self):
		core.register('open_mailfolder_host', self)
		core.register('open_mailfolder', self)
		core.register('open_mail', self)
		core.register('move_mail', self)
		core.register('mailping_update', self)
		core.register('mailhdrs_update', self)
		core.register('mailuids_update', self)
		core.register('mailenvelope_update', self)
		core.register('folder_expunged', self)
		core.register('close_mailfolder', self)
		core.register('close_mailfolder_host', self)
		self.mail_hosts = {}
	def getfolder(self, folder):
		host = self.mail_hosts.get(folder.cf.name)
		if host is None:
			return None, None
		else:
			fwin = host.fwin.get(folder.name)
			if fwin and not fwin.qzmessenger.IsValid():
				fwin = None
				self.delfolder(folder)
			return fwin, host
	def setfolder(self, folder, win):
		host = self.mail_hosts.get(folder.cf.name)
		host.fwin[folder.name] = win
	def delfolder(self, folder):
		host = self.mail_hosts.get(folder.cf.name)
		if host:
			try:
				del host.fwin[folder.name]
			except KeyError:
				pass
			if not host.win and not host.fwin:
				del self.mail_hosts[folder.cf.name]
				self.imap.close(folder.cf)
	def open_mailfolder_host(self):
		cf = configure.cf
		h = self.mail_hosts.get(cf.name)
		if h is None:
			h = Host()
		if h.win is None:
			h.win = FolderList(cf, self.imap.server(cf))
		self.mail_hosts[cf.name] = h
		h.win.service.pingall(h.win.list[:])
	def open_mailfolder(self, folder, limit):
		fwin, host = self.getfolder(folder)
		if not fwin:
			srv = self.imap.server(folder.cf)
			f = MessageList(folder, srv)
			self.setfolder(folder, f)
			srv.ping(folder)
	def mailping_update(self, folder, count, recent):
		#  Data arrives about the number of messages and
		#  recent messages in the folder.  If the folder's
		#  host is displayed, update this item in that
		#  display.  If the folder is displayed, clue it so
		#  it can update its message list.

		#  The requirement for a MailFolder instance is awkward
		#  here, because the BMessageRunner needs to pass this
		#  on through a BMessage to trigger the ping.
		#  Maybe the service thread should store the list of
		#  folders ... read only, anyway ... and the message
		#  just triggers the ping series.

		fwin, host = self.getfolder(folder)
		if host and host.win and not host.win.qzmessenger.IsValid():
			# print host, 'is no more!'
			host.win = None
		if host and host.win:
			host.win.ping_update(folder, count, recent)
		if fwin:
			fwin.ping_update(count, recent)
	def mailhdrs_update(self, folder, first, statuslist):
		fwin, host = self.getfolder(folder)
		if fwin:
			fwin.hdrs(first, statuslist)
	def mailenvelope_update(self, folder, first, statuslist):
		fwin, host = self.getfolder(folder)
		if fwin:
			fwin.envelope(first, statuslist)
	def mailuids_update(self, folder, folderid, statuslist):
		fwin, host = self.getfolder(folder)
		if fwin:
			fwin.uids(folderid, statuslist)
	def close_mailfolder(self, folder):
		self.delfolder(folder)
	def close_mailfolder_host(self, cf):
		h = self.mail_hosts.get(cf.name)
		if h:
			h.win = None
		if not h or not h.fwin:
			self.imap.close(cf)
	def open_mail(self, folder, message):
		win = NoteWindow('%s:%s' % (folder.name, message.id), message)
		win.run()
		# if file is None:
		if message.actual:
			win.damage()
		else:
			srv = self.imap.server(folder.cf)
			srv.getmessage(win, folder, message.id)
	def move_mail(self, folder, id):
		fwin, host = self.getfolder(folder)
		if host and host.win and not host.win.qzmessenger.IsValid():
			print >> sys.stderr, host, 'is no more!'
			host.win = None
		if host and host.win:
			host.win.movemail(folder, id)
	def folder_expunged(self, folder):
		fwin, host = self.getfolder(folder)
		if fwin:
			fwin.expunged()
