#  Copyright 1999 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.
#
#  Main window.
#

import pickle
import string

from BBox import BBox
from BMenu import BMenu
from BMenuBar import BMenuBar
from BMenuItem import BMenuItem
from BMessage import BMessage
from BRadioButton import BRadioButton
from BStatusBar import BStatusBar
from BStringView import BStringView
from BWindow import BWindow

from errpt import LastChanceLooper

import blindprompt
import configure
from core import core
from queue import CallQueue
import BApplication

from AppKit import B_QUIT_REQUESTED
from InterfaceKit import B_PLAIN_BORDER,B_NO_BORDER,B_FANCY_BORDER, \
    B_FOLLOW_ALL,B_FOLLOW_LEFT,B_FOLLOW_TOP,B_FRAME_EVENTS,B_TITLED_WINDOW, \
    B_NOT_ZOOMABLE,B_NOT_RESIZABLE,B_WILL_DRAW,B_NAVIGABLE

class MenuWindow(LastChanceLooper, CallQueue, BWindow):
	comname = 'mainwindow'
	def __init__(self):
		frame = configure.getframe(MenuWindow.comname)
		if not frame:
			frame = (100.0, 80.0, 400.0, 240.0)
		BWindow.__init__(self, frame, MenuWindow.comname,
			B_TITLED_WINDOW, B_NOT_ZOOMABLE)
		# if cfframe:
		# 	l, t, r, b = cfframe
		# 	if l != frame[0] or t != frame[1]:
		# 		self.MoveTo(l, t)
		# 	if r - l != frame[2] - frame[0] or b - t != frame[3] - frame[1]:
		# 		self.ResizeTo(r - l, b - t)
		# 	frame = cfframe
		# set up a rectangle and instantiate a new view
		# import time
		# time.sleep(20.0)
		bounds = self.Bounds()
		self.top = BBox(bounds, 'top', B_FOLLOW_ALL,
			B_WILL_DRAW|B_NAVIGABLE, B_NO_BORDER)

		#  Create a menu bar, and populate with a couple of
		#  menus.  Items like "open_mailfolder_host" are
		#  retargeted to the application thread.

		self.bar = BMenuBar(bounds, 'Bar')
		menu = BMenu('Mail')
		item = self.mkmenuitem('open', 'open_mailfolder_host', ())
		menu.AddItem(item)
		item.SetTarget(core.target('open_mailfolder_host'))
		self.bar.AddItem(menu)

		menu = BMenu('News')
		item = self.mkmenuitem('open', 'open_newsgroup_host', ())
		menu.AddItem(item)
		item.SetTarget(core.target('open_newsgroup_host'))
		self.bar.AddItem(menu)

		#  Set default character sets for incoming and outgoing.
		#  These really should be in a configuration screen.
		menu = BMenu('Charset')
		for m in (('ics_dfl', 'Read'), ('ocs_dfl', 'Post')):
			m, n = m
			item = BMenu(n)
			for f in ('ISO-8859-1', 'UTF-8'):
				item.AddItem(self.mkmenuitem(f, 'setcharset', (m, f), 1))
			menu.AddItem(item)
		self.bar.AddItem(menu)

		#  Clear out some space and put in radio buttons for the
		#  various accounts.  (What, you have only one account!?
		#  Well, this is going to look kind of stupid, isn't it!)
		l, t, r, b = bounds
		l = l + 20.0
		t = 30.0
		r = l + 50.0
		b = t + 20.0
		for cf in configure.cflist:
			msg = self.qzsetfnmsg('setaccount', (cf.name,))
			rb = BRadioButton((l, t, r, b), cf.name, cf.name, msg)
			self.top.AddChild(rb)
			if cf.name == configure.cf.name:
				rb.SetValue(1)
			l = l + 60.0
			r = r + 60.0
		self.top.AddChild(self.bar)

		#  Clear off some more space and put messages there.
		l, t, r, b = bounds
		diboxbounds = (l + 10.0, t + 60.0, r - 10.0, b - 40.0)
		self.dibox = BBox(diboxbounds, 'diag', B_FOLLOW_ALL,
			B_WILL_DRAW|B_FRAME_EVENTS, B_FANCY_BORDER)
		self.dibox.SetLabel('Status')
		self.top.AddChild(self.dibox)

		# l, t, r, b = diboxbounds
		w = diboxbounds[2] - diboxbounds[0]
		self.statfrm = (10.0, 12.0, w - 10.0, t + 30.0)
		self.statv = {}

		l, t, r, b = bounds
		self.stbar = BStatusBar((l + 10.0, b - 40.0, r - 10.0, b - 12.0), 'stbar')
		self.top.AddChild(self.stbar)
		self.curst = None
		self.stbar.Hide()
        	self.AddChild(self.top)

		core.register('report', self)
		core.register('pctview', self)
		self.qzinit(BWindow)

	def mkmenuitem(self, name, fn, args, enable = 1):
		msg = self.qzsetfnmsg(fn, args)
		item = BMenuItem(name, msg)
		if not enable:
			item.SetEnabled(0)
		return item

	def pctview(self, pct, id):
		#  Progress bar control function.  The id parameter
		#  mainly helps avoid confusion about whose status
		#  this is - can display progress of only one thing
		#  at a time.

		if id is None:
			self.stbar.Hide()
			self.curst = None
		elif self.curst is None:
			self.curst = id
			self.stbar.Reset()
			self.stbar.Show()
			if pct:
				self.stbar.Update(pct)
		elif self.curst == id:
			self.stbar.Update(pct)

	def report(self, svc, stv, sts):
		try:
			s = self.statv[svc]
		except KeyError:
			s = BStringView(self.statfrm, svc, '')
			self.statv[svc] = s
			self.dibox.AddChild(s)
			l, t, r, b = self.statfrm
			self.statfrm = (l, t + 16, r, b + 16)
		s.SetText('%s: %s' % (svc, sts))

	def setaccount(self, newacct):
		oldacct = configure.cf.name
		configure.setdefault(newacct)
		return 1

	def setcharset(self, io, cs):
		print 'setcharset', repr(io), repr(cs)
		val = string.lower(cs)
		setattr(configure.cf, io, val)

	def QuitRequested(self):
		configure.saveframe(self.comname, self.Frame())
		core('exit', 0)
		return 1
