#  Copyright 1999 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.
#

import imap
import string
import tempfile
import time
import socket
import select
import sys

from core import core
import kernel

from queue import exportii, CallQueue

from BLooper import BLooper

def svc_host(svc_conn):
        return socket.gethostbyaddr(svc_conn.getpeername()[0])[0]

#  getauth()
#
#  Tries to load the authentication plugin module and initialize an
#  authentication object from it. This plugin is discovered by the
#  simple expedient of an expected name for the module, "authplugin",
#  and function "AuthPlugin".  

def getauth(service_name, svc_conn, login):
	try:
		import authplugin
		for authname, authfun in authplugin.plugins:
			# print 'Trying authentication method', authname
			try:
				auth = authfun(service_name,
					svc_host(svc_conn), login)
			except authfun.LocalInvalid, val:
				# authplugin.LocalInit(login)
				print 'Authentication error:', val
				auth = None
			except authfun.UnknownError, val:
				print 'Error starting authentication', val
				auth = None
	except ImportError:
		auth = None
	return auth

class Folder:
	PINGTIME = 5
	def __init__(self, name):
		self.name = name
		self.stime = 0
	def update(self, service):
		for k in ('EXISTS', 'RECENT'):
			s = service.untagged_responses.get(k)
			if s and s[-1]:
				setattr(self, k, s[-1])
				service.untagged_responses[k] = []
				t = 1
		#  As long as this function is called only after a
		#  response from the server, it doesn't matter whether
		#  the server actually said anything - if there's any
		#  news, it will say something.
		self.stime = time.time()
	def stale(self):
		return time.time() - self.stime > self.PINGTIME

class IMAP4(CallQueue, BLooper):
	error = Exception
	PING = 110
	def __init__(self, cf):
		self.service = None
		self.server = None
		self.failing = 0
		self.idle = 0
		self.mayidle = 0
		self.cf = cf
		self.name = '%s IMAP' % (self.cf.name,)
		self.report(7, 'No connection yet')
		self.currentfolder = None
		self.ready = 0
		BLooper.__init__(self, self.name)
		self.Run()
		self.qzinit(BLooper)

	def MessageReceived(self, msg):
		if msg.what == self.PING:
			self.iipingall(None)
		else:
			CallQueue.MessageReceived(self, msg)

	def report(self, stv, sts):
		core('report', self.name, stv, sts)

	def pctview(self, x):
		core('pctview', x, id(self))

	def start_retry(self):
		if self.failing:
			return 0
		else:
			print '----- reconnect starting -----'
			self.failing = 1
			self.service = None
			self.connect()
			print '----- OK to retry -----'
			return 1

	def pass_retry(self):
		self.failing = 0

	def catchuntagged(self):
		if self.currentfolder:
			self.currentfolder.update(self.service)
		self.idle = 0

	def _folderstatus(self, folder, issues):
		if not self.ready:
			self.connect()
		if self.idle:
			self.service.unidle()
			self.idle = 0
		try:
			#  Did you know, this command can cause the
			#  server to accidentally unlock the selected
			#  folder, when the file descriptor opened
			#  separately on it for this command closes?
			#  POSIX 1003.1 brain damage!  Anyway, that's
			#  the theory, so don't status the selected folder.

			ok, response = self.service.status(folder.name,
				'(%s)' % (string.join(issues, ' ',)))
		except self.service.abort:
			if self.start_retry():
				return self._folderstatus(folder, issues)
			else:
				raise
		self.pass_retry()
		# if ok != 'OK':
		# 	print 'Faking status OK-ness from', ok, response
		# 	response = self.service.untagged_responses['STATUS']
		# 	ok = 'OK'
		if ok != 'OK':
			self.report(7, str(response))
			raise self.error(response)
		self.catchuntagged()  # while we're at it.
		stuff = string.split(response[0], '(')
		stuff = string.split(stuff[1], ')')
		stuff = string.split(stuff[0])
		res = []
		for issue in issues:
			while stuff:
				if stuff[0] == issue:
					res.append(stuff[1])
					stuff = stuff[2:]
					break
			else:
				res.append('')
				stuff = stuff[1:]
		return tuple(res)

	def _update(self, ping = 1):
		# must have selected.
		c = self.currentfolder
		if not c:
			return
		if ping and c.stale():
			if self.mayidle:
				if self.idle:
					#  If IDLE past 20 minutes, stop.
					#  That will kick the logout timer (?),
					#  and we'll get untagged responses
					#  without the select+recv (?)
					#  Failing any other action, next
					#  time through here we'll go idle.
					#
					if time.time() - self.idle > 600:
						self.service.unidle()
						self.idle = 0
						self.report(5, 'leaving IDLE state')
				else:
					self.service.idle()
					self.idle = time.time()
			else:
				#  So much simpler to just bang it with a NOOP.
				ok, resp = self.service.noop()
		else:
			pass
		if self.idle:
			s = time.time() - self.idle
			m = s / 60
			s = s % 60
			self.report(5, 'IDLE %d:%d' % (m, s))
			r, w, e = select.select([self.service.sock.fileno()], [], [], 0.0)
			if r:
				self.service._get_response()
			else:
				return
		c.update(self.service)

	def _select(self, folder):
		if not self.ready:
			self.connect()
		if self.idle:
			self.service.unidle()
			self.idle = 0
		c = self.currentfolder
		if c and folder.name == c.name:
			self._update()
		else:
			self.report(5, 'visiting folder %s' % (folder.name,))
			try:
				ok, stuff = self.service.select(folder.name)
			except self.service.abort:
				if self.start_retry():
					return self._select(folder)
				else:
					raise
			self.pass_retry()

			#  If reselecting same folder, some imap service
			#  implementations return something like
			#  "OK, ignoring re-select" which doesn't really
			#  conform to the 4rev1 RFC and confuses imaplib.

			if ok == 'OK':
				self.currentfolder = Folder(folder.name)
				self.currentfolder.uidvalidity = self.service.untagged_responses.get('UIDVALIDITY')
				self._update(0)
			else:
				raise self.error(stuff)

	def connect(self):
		if self.service == None:
			if self.server == None:
				self.server = self.cf.imapserver
				if type(self.server) == type(''):
					self.server = (self.server,)
			self.report(6, 'Connecting to %s' % (self.server,))
			self.service = apply(imap.IMAP4, self.server)

			#  IDLE means you get asynchronous new mail updates.
			#  But not necessarily all that promptly, and you
			#  do still have to put in a ping before 30 minutes
			#  to stay connected.

			# if 'IDLE' in self.service.capabilities:
			# 	self.mayidle = 1
			try:
				authtypes = self.cf.authtypes
			except AttributeError:
				authtypes = None
			try:
				username, password = self.cf._upw
			except AttributeError:
				username = None
				password = None
			if password is None:
				if authtypes is None:
					self.login(None, None)
				elif 'AUTH=GSSAPI' in self.service.capabilities:
					try:
						a = getauth('imap',
							self.service.sock,
							self.cf.login)
					except:
						a = None
					if a:
						self.service.authenticate(a.name, a)
						self.ready = 1
			else:
				self.login(username, password)
		return 1

	def iigetenvelope(self, folder, first, last):
		self._select(folder)
		#  first, last will usually be integers, but
		#  move() may for example call with strings.
		if type(first) == type(''):
			first = string.atoi(first)
		if type(last) == type(''):
			last = string.atoi(last)
		if self.idle:
			self.service.unidle()
			self.idle = 0
		try:
			ok, stuff = self.service.fetch('%s:%s' % (first, last),
				'(FLAGS ENVELOPE)')
		except self.service.abort:
			if self.start_retry():
				return self.iigetenvelope(folder, first, last)
			else:
				raise
		self.pass_retry()
		if ok != 'OK':
			self.report(7, str(stuff))
			raise self.error(stuff)
		self.catchuntagged()
		# Some date
		# Subject
		# From/ReplyTo/Sender
		# From/ReplyTo/Sender
		# From/ReplyTo/Sender
		# Recipient
		# ?
		# ?
		# ?
		# Message-ID
		list = []
		for item in stuff:
			id, fl, item = string.split(item, ' (', 2)
			fl, item = string.split(item, ') ', 1)
			flag = []
			for fl in string.split(fl):
				flag.append(fl[1:])
			en, env = string.split(item, ' (', 1)
			list.append((id, flag, env[:-1]))
		core('mailenvelope_update', folder, first, list)

	def iigethdrs(self, folder, first, last):
		self._select(folder)
		#  first, last will usually be integers, but
		#  move() may for example call with strings.
		if type(first) == type(''):
			first = string.atoi(first)
		if type(last) == type(''):
			last = string.atoi(last)
		if self.idle:
			self.service.unidle()
			self.idle = 0
		try:
			ok, stuff = self.service.fetch('%s:%s' % (first, last),
				'(UID FLAGS RFC822.HEADER)')
		except self.service.abort:
			if self.start_retry():
				return self.iigethdrs(folder, first, last)
			else:
				raise
		self.pass_retry()
		if ok != 'OK':
			self.report(7, str(stuff))
			raise self.error(stuff)
		self.catchuntagged()
		list = []
		for i in range(0, len(stuff), 2):
			try:
				spud, head = stuff[i]
			except:
				print 'Unexpected response', stuff[i]
				raise
			# '12 (UID 17 FLAGS (\\Seen) RFC822.HEADER {2062}'
			id, uid, spud = string.split(spud, ' (')
			waste, uid, w2 = string.split(uid)
			spud, waste = string.split(spud, ') ')
			spud = string.split(spud)
			flag = []
			for s in spud:
				flag.append(s[1:])  # strip "\"
			list.append((id, uid, flag, head))
		core('mailhdrs_update', folder, first, list)

	def iigetuids(self, folder, first, last):
		self._select(folder)
		#  first, last will usually be integers, but
		#  move() may for example call with strings.
		if type(first) == type(''):
			first = string.atoi(first)
		if type(last) == type(''):
			last = string.atoi(last)
		if self.idle:
			self.service.unidle()
			self.idle = 0
		try:
			ok, stuff = self.service.fetch('%s:%s' % (first, last),
				'(UID FLAGS)')
		except self.service.abort:
			if self.start_retry():
				return self.iigethdrs(folder, first, last)
			else:
				raise
		self.pass_retry()
		if ok != 'OK':
			self.report(7, str(stuff))
			raise self.error(stuff)
		self.catchuntagged()
		list = []
		for spud in stuff:
			# '12 (UID 17 FLAGS (\\Seen))'
			id, uid, spud = string.split(spud, ' (')
			waste, uid, w2 = string.split(uid)
			# spud, waste, w2 = string.split(spud, ')')
			spud = spud[:-2]
			spud = string.split(spud)
			flag = []
			for s in spud:
				flag.append(s[1:])  # strip "\"
			list.append((id, uid, flag))
		core('mailuids_update', folder, self.currentfolder.uidvalidity, list)

	def iiflagmessage(self, folder, number, flag):
		self._select(folder)
		if flag[:1] == '-':
			flc = '-Flags'
			flag = flag[1:]
		else:
			flc = '+Flags'
			if flag[:1] == '+':
				flag = flag[1:]
		fle = '(\%s)' % (flag,)
		self.report(5, '%s %s message %s %s' % (flc, fle, folder.name, number))
		if self.idle:
			self.service.unidle()
			self.idle = 0
		try:
			ok, stuff = self.service.store(number, flc, fle)
		except self.service.abort:
			if self.start_retry():
				return self.iiflagmessage(folder, number, flag)
			else:
				raise
		self.pass_retry()
		if ok != 'OK':
			self.report(7, str(stuff))
			raise self.error(stuff)
		self.catchuntagged()
		if type(number) == type(''):
			number = string.atoi(number)
		self.iigethdrs(folder, number, number)

	def iiexpunge(self, folder):
		if not self.ready:
			return 0
		self._select(folder)
		if self.idle:
			self.service.unidle()
			self.idle = 0
		self.report(5, 'expunging %s' % (folder.name,))
		try:
			ok, stuff = self.service.expunge()
		except self.service.abort:
			if self.start_retry():
				return self.iiexpunge(folder)
			else:
				raise
		self.pass_retry()
		if ok != 'OK':
			self.report(7, str(stuff))
			raise self.error(stuff)
		self.catchuntagged()
		core('folder_expunged', folder)

	def iigetmessage(self, thr, folder, number):
		self._select(folder)
		self.report(5, 'getting %s message %s' % (folder.name, number))
		if self.idle:
			self.service.unidle()
			self.idle = 0
		self.service.setpercentview(self.pctview)
		self.pctview(None)
		try:
			ok, stuff = self.service.fetch(number, '(RFC822)')
		except self.service.abort:
			self.service.setpercentview(None)
			if self.start_retry():
				return self.iigetmessage(thr, folder, number)
			else:
				raise
		else:
			self.service.setpercentview(None)
			core('pctview', None, None)
		self.pass_retry()
		if ok != 'OK':
			self.report(7, str(stuff))
			raise self.error(stuff)
		self.catchuntagged()
		spud, msg = stuff[0]
		id, spud = string.split(spud, ' (')
		# file = open(filename, 'w')
		lines = []
		st = 0
		li = 0
		while 1:
			li = li + 1
			# en = string.find(msg, '\r', st)
			en = string.find(msg, '\r\n', st)
			if en >= 0:
				# file.write(msg[st:en])
				lines.append(msg[st:en])
				# st = en + 1
				st = en + 2
			else:
				# file.write(msg[st:])
				lines.append(msg[st:])
				break
		# file.close()
		# self.report(0, '%s %s %d lines' % (id, filename, li))
		self.report(0, '%s %d lines' % (id, li))
		thr.message(lines)

	def login(self, me, password):
		if not me:
			me = self.cf.login
		while 1:
			if password:
				try:
					ok, stuff = self.service.login(me, password)
				except self.service.error, val:
					print 'Error:', val, repr(val)
					ok = 'not!'
					stuff = str(val)
				if ok == 'OK':
					self.report(5, '%s' % (stuff,))
					self.ready = 1
					self.cf._upw = (me, password)
					break
				else:
					self.report(7, '%s' % (stuff,))
			sem = kernel.create_sem(0, 'passprompt')
			core('blind_prompt', 'Password for %s' % (me,), '', sem)
			password = core.takeswitch(sem)
			kernel.delete_sem(sem)
			if password is None:
				self.purge()
				self.iilogout()
				return 1

	def iilogout(self):
		if self.service:
			self.report(5, 'log off')
			if self.idle:
				self.service.unidle()
				self.idle = 0
			try:
				self.service.logout()
			except self.service.abort:
				pass
		self.Quit()

	def iimove(self, old, id, new):
		self._select(old)
		if self.idle:
			self.service.unidle()
			self.idle = 0
		try:
			ok, stuff = self.service.copy(id, new.name)
		except self.service.abort:
			if self.start_retry():
				return self.iimove(old, id, new)
			else:
				raise
		self.pass_retry()
		if ok != 'OK':
			self.report(7, str(stuff))
			raise self.error(stuff)
		ok, stuff = self.service.store(id, 'FLAGS', '(\Deleted)')
		if ok != 'OK':
			self.report(7, str(stuff))
			raise self.error(stuff)
		# OK, that was the easy part.  Now, must notify the
		# original window, possibly the target's window, and
		# the parent folderlist window.
		self.iigethdrs(old, id, id)
		self.iiping(new)

	def iipingall(self, folderlist):
		if folderlist is None:
			folderlist = self.saved_folderlist
		else:
			# Is it OK to store this stuff across threads?
			# Caller should make [:] copy, at least.
			self.saved_folderlist = folderlist
		for folder in folderlist:
			if folder.ping:
				self.iiping(folder)

	def iiping(self, folder):
		if not self.ready:
			self.connect()
		c = self.currentfolder
		if c and c.name == folder.name:
			self._update()
			count = c.EXISTS
			recent = c.RECENT
		else:
			count, recent = self._folderstatus(folder, ('MESSAGES', 'RECENT'))
		count = string.atoi(count)
		recent = string.atoi(recent)
		core('mailping_update', folder, count, recent)

	exec(exportii(locals()))
