#  Copyright 1999 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.
#
#  Subclass of Message for NNTP articles.
#  Also fields class to direct display of data in columns, in BListView with
#  custom ListItems.
#
import string

from AppKit import B_QUIT_REQUESTED

import configure
from note import Note

class NewsNote(Note):
	htags = ('From', 'Subject', 'Message-ID', 'References')
	tags = ('ID',) + htags
	width = (50.0, 200.0, 300.0, 0.0, 0.0)
	stdheaders = ('From', 'To', 'Date', 'Subject', 'Newsgroups')
	rplheaders = ('From', 'Subject', 'Newsgroups',
		'References', 'X-In-Reply-To', 'X-Newsreader', 'MIME-Version', 'Content-Type', 'Content-Encoding')
	def fromscan(self, id, fields):
		#  Called with results from xhdr() service request,
		#  initializes message data for list display.
		self.id = id
		self.hd = {}
		for i in range(len(self.htags)):
			key = self.htags[i]
			value = fields[i]
			e = self.qqhdr(value)
			if not (e is value):
				fields[i] = e
				value = e
			self.hd[key] = value
		self.value = (id,) + tuple(fields)
	def replyheaders(self):
		hl = []
		for h in self.rplheaders:
			if h == 'From':
				me = (configure.cf.realname,
					configure.cf.returnaddress)
				
				me = self.formataddress((me,))
				hl.append('From: %s' % me)
			elif h == 'X-Newsreader':
				hl.append('X-Newsreader: BeOS-PyNR V1')
			elif h == 'MIME-Version: 1.0':
				hl.append('MIME-Version: 1.0')
			elif h == 'Content-Type':
				if getattr(configure.cf, 'ocs_dfl', None) == 'utf-8':
					hl.append('Content-Type: text/plain; charset=UTF-8')
				else:
					hl.append('Content-Type: text/plain; charset=ISO-8859-1')
			elif h == 'Content-Encoding':
				hl.append('Content-Encoding: 8bit')
			elif h == 'References':
				refs = self.getheader('References')
				id = self.getheader('Message-ID')
				if refs == '(none)':
					hl.append('References: %s' % id)
				else:
					hl.append('References: %s %s' % (refs, id))
			else:
				if h == 'X-In-Reply-To':
					gh = 'From'
				else:
					gh = h
				v = self.getheader(gh)
				if v:
					if h == 'Subject' and string.lower(v[:4]) != 're: ':
						hl.append('%s: Re: %s' % (h, v))
					else:
						hl.append('%s: %s' % (h, v))
		return hl
