#  Copyright 1999 by Donn Cave, Seattle, Washington, USA.
#  All rights reserved.  Permission to copy, modify and distribute this
#  material is hereby granted, without fee, provided that the above
#  copyright notice appear in all copies.
#
#  Simple SMTP reply.
#
import rfc822
import smtplib
import string

import configure

def sendreply(msg):
	a = msg.rfc822.getaddrlist('To')
	if not a:
		a = msg.rfc822.getaddrlist('X-In-Reply-To')
	if not a:
		return '(No "To" specified in reply message.\n)'
	dest = []
	for name, addr in a:
		dest.append(addr)
	a = msg.rfc822.getaddrlist('Cc')
	if a:
		for name, addr in a:
			dest.append(addr)
	fp = open(msg.file.name, 'r')
	ft = string.join(string.split(fp.read(1024 * 1024), '\n'), '\r\n')
	srv = smtplib.SMTP(configure.cf.smtpserver)
	d = srv.sendmail(configure.cf.returnaddress, dest, ft)
	et = ''
	for a,e in d.items():
		et = et + '%s: %s\n' % (repr(a), repr(e))
	srv.quit()
	return et
