//  Copyright 1999 by Donn Cave, Seattle, Washington, USA.
//  All rights reserved.  Permission to copy, modify and distribute this
//  material is hereby granted, without fee, provided that the above
//  copyright notice appear in all copies.

#include <stdio.h>
#include <string.h>

#include <support/UTF8.h>

#include <Python.h>

static PyObject *PysupportError;
static PyObject *module_dict;

static PyObject *
Pysupport_convert_to_utf8(PyObject *module, PyObject *args)
{
	uint32 cvtype;
	long inlen, outlen;
	char *input, *output;
	status_t status;

	if (!PyArg_Parse(args, "(is#)", &cvtype, &input, &inlen)) {
		// PyErr_SetString(PyExc_TypeError, "convert_to_utf8(int, str)");
		return 0;
	}
	if (inlen == 0)
		return PyString_FromString("");
	output = (char *) malloc(inlen * 2);
	if (!output) {
		PyErr_SetString(PyExc_MemoryError, "output");
		return 0;
	}
	outlen = inlen * 2;
	status = convert_to_utf8(cvtype, input, &inlen, output, &outlen, 0);
	if (status != B_OK) {
		PyErr_SetString(PysupportError, strerror(status));
		return 0;
	}
	output = (char *) realloc(output, outlen + 1);
	return PyString_FromStringAndSize(output, outlen);
}

static PyObject *
Pysupport_convert_from_utf8(PyObject *module, PyObject *args)
{
	uint32 cvtype;
	long inlen, outlen;
	char *input, *output;
	status_t status;

	if (!PyArg_Parse(args, "(is#)", &cvtype, &input, &inlen)) {
		// PyErr_SetString(PyExc_TypeError, "convert_from_utf8(int, str)");
		return 0;
	}
	if (inlen == 0)
		return PyString_FromString("");
	output = (char *) malloc(inlen * 2);
	if (!output) {
		PyErr_SetString(PyExc_MemoryError, "output");
		return 0;
	}
	outlen = inlen * 2;
	status = convert_from_utf8(cvtype, input, &inlen, output, &outlen, 0);
	if (status != B_OK) {
		PyErr_SetString(PysupportError, strerror(status));
		return 0;
	}
	output = (char *) realloc(output, outlen + 1);
	return PyString_FromStringAndSize(output, outlen);
}

static struct PyMethodDef support_global_methods[] = {
	{"convert_to_utf8",  Pysupport_convert_to_utf8, 0},
	{"convert_from_utf8",  Pysupport_convert_from_utf8, 0},
	{NULL,		NULL}		/* sentinel */
};

extern "C" void
initsupport()
{
	PyObject *mod = Py_InitModule("support", support_global_methods);
	module_dict = PyModule_GetDict(mod);
	PysupportError = PyErr_NewException("support.error", 0, 0);
	PyDict_SetItemString(module_dict, "error", PysupportError);
}
