/*
	Copyright (c) 2002, Thomas Kurschel
	based on Screen Preferences Panel written for OpenBeOS by Rafael Romo


	Part of Radeon Screen Preferences
		
	Window for user-selected refresh rate
*/

#ifndef REFRESHWINDOW_H
#define REFRESHWINDOW_H

#include <Window.h>

#include "RefreshView.h"
#include "RefreshSlider.h"

class RefreshWindow : public BWindow
{

public:
						RefreshWindow( BWindow *screenWindow, BRect frame, int32 refresh10 );
	virtual	bool		QuitRequested();
	virtual void 		MessageReceived(BMessage *message);
	virtual void		WindowActivated(bool active);

private:
	RefreshView			*fRefreshView;
	RefreshSlider		*fRefreshSlider;
	BButton				*fDoneButton;
	BButton				*fCancelButton;
	BWindow				*fScreenWindow;
};

#endif


