/*
	Copyright (c) 2002, Thomas Kurschel
	based on Screen Preferences Panel written for OpenBeOS by Rafael Romo


	Part of Radeon Screen Preferences
		
	Draws little monitor icon in main window
*/

#include <Message.h>
#include <Screen.h>
#include <Roster.h>
#include <View.h>

#include "ScreenDrawView.h"
#include "Constants.h"

ScreenDrawView::ScreenDrawView(BRect rect, char *name)
	: BView(rect, name, B_FOLLOW_ALL, B_WILL_DRAW)
{
	fWidth = fHeight = 100;
	
	desktopColor = BScreen(B_MAIN_SCREEN_ID).DesktopColor(current_workspace());
}

void ScreenDrawView::AttachedToWindow()
{
	rgb_color greyColor = {216, 216, 216, 255};
	SetViewColor(greyColor);
}

void ScreenDrawView::MouseDown(BPoint point)
{
	be_roster->Launch("application/x-vnd.Be-BACK");
}

BRect ScreenDrawView::Resolution2PictureRect( int width, int height )
{
	float maxWidth, maxHeight;
	float picWidth, picHeight;
	
	maxWidth = Bounds().Width();
	maxHeight = Bounds().Height();
	
	picWidth = maxWidth * width / 1600;
	picHeight = maxHeight * height / 1200;
	
	if( picWidth > maxWidth ) {
		picHeight = picHeight * maxWidth / picWidth;
		picWidth = maxWidth;
	}
		
	if( picHeight > maxHeight ) {
		picWidth = picWidth * maxHeight / picHeight;
		picHeight = maxHeight;
	}
		
	return BRect( 
		(maxWidth - picWidth) / 2, (maxHeight - picHeight) / 2, 
		(maxWidth + picWidth) / 2, (maxHeight + picHeight) / 2 );
}

void ScreenDrawView::Draw(BRect updateRect)
{
	rgb_color darkColor = {160, 160, 160, 255};
	rgb_color blackColor = {0, 0, 0, 255};
	rgb_color redColor = {228, 0, 0, 255};
	BRect outerRect = Resolution2PictureRect( fWidth, fHeight );
	BRect innerRect;
	BPoint redPos;
		
	SetHighColor(darkColor);

	FillRoundRect( outerRect, 3.0, 3.0);
	
	SetHighColor(blackColor);
	
	StrokeRoundRect( outerRect, 3.0, 3.0);
	
	SetHighColor(desktopColor);

	innerRect = outerRect;
	innerRect.left += 4;
	innerRect.right -= 4;
	innerRect.top += 4;
	innerRect.bottom -= 4;
	
	FillRoundRect( innerRect, 2.0, 2.0);
	
	SetHighColor(blackColor);
	
	StrokeRoundRect( innerRect, 2.0, 2.0);
	
	SetHighColor(redColor);
	
	redPos = BPoint( outerRect.left + 5, outerRect.bottom - 2 );
	
	StrokeLine( redPos, BPoint( redPos.x + 2, redPos.y ));
	
	return;
}

void ScreenDrawView::MessageReceived(BMessage* message)
{
	switch(message->what)
	{
		case UPDATE_DESKTOP_MSG:
		{
			message->FindInt32( "width", &fWidth );
			message->FindInt32( "height", &fHeight );

			Invalidate();
			break;
		}
	
		case UPDATE_DESKTOP_COLOR_MSG:
		{
			desktopColor = BScreen( B_MAIN_SCREEN_ID ).DesktopColor(current_workspace());
			
			Invalidate();
		}
		
		default:
			BView::MessageReceived(message);
			
			break;
	}
}
