#include <Window.h>
#include <View.h>
#include <InterfaceKit.h>
#include <stdlib.h>
#include <stdio.h>

#include "Globals.h"
#include "RealtimeFilter.h"
#include "BassBoostFilter.h"

/*******************************************************
*   
*******************************************************/
BassBoostFilter::BassBoostFilter(bool b) : RealtimeFilter(Language.get("BASSBOOST"), b)
{

}

/*******************************************************
*   
*******************************************************/
BView *BassBoostFilter::ConfigView()
{
	BRect r(0,0,200,100);

	BView *view = new BView(r, NULL, B_FOLLOW_ALL, B_WILL_DRAW);
	view->SetViewColor(ui_color(B_PANEL_BACKGROUND_COLOR));

	r.InsetBy(8,8);
	r.bottom = r.top + 23;
	freq = new SpinSlider(r, NULL, Language.get("BB_FREQUENCY"), new BMessage(CONTROL_CHANGED), 1, 1000);
	freq->SetValue(Prefs.filter_bassboost_frequency);
	view->AddChild(freq);

	r.OffsetBy(0,40);
	boost = new SpinSlider(r, NULL, Language.get("BB_BOOST"), new BMessage(CONTROL_CHANGED), 0, 24);
	boost->SetValue(Prefs.filter_bassboost_boost);
	view->AddChild(boost);

	return view;
}

void BassBoostFilter::UpdateValues()
{
	Prefs.filter_bassboost_frequency = freq->Value();
	Prefs.filter_bassboost_boost = boost->Value();
}

/*******************************************************
*   Init & exit
*******************************************************/
bool BassBoostFilter::InitFilter(float f, int32 c, int32 pass, int32 size)
{
	RealtimeFilter::InitFilter(f, c);

	xn1 = 0, xn2 = 0, yn1 = 0, yn2 = 0;
	xn3 = 0, xn4 = 0, yn3 = 0, yn4 = 0;

	return true;
}

void BassBoostFilter::DeAllocate()
{
}

/*******************************************************
*   
*******************************************************/
void BassBoostFilter::FilterBuffer(float *buffer, size_t size)
{
	/* Compute coefficents of the biquand IIR filter */
	float omega = 2 * 3.141592653589 * Prefs.filter_bassboost_frequency / m_frequency;
	float sn = sin(omega);
	float cs = cos(omega);
	float a = exp(log(10) * Prefs.filter_bassboost_boost / 40);
	float shape = 1.0;           /*Low Shelf filter's shape, if this is too large
                                   or too small it will result an unstable filter */
	float beta = sqrt((a * a + 1) / shape - (pow((a - 1), 2)));
	/*  Coefficients  */
	float b0 = a * ((a + 1) - (a - 1) * cs + beta * sn);
	float b1 = 2 * a * ((a - 1) - (a + 1) * cs);
	float b2 = a * ((a + 1) - (a - 1) * cs - beta * sn);
	float a0 = ((a + 1) + (a - 1) * cs + beta * sn);
	float a1 = -2 * ((a - 1) + (a + 1) * cs);
	float a2 = (a + 1) + (a - 1) * cs - beta * sn;
	/* initialise the filter */

	float out, in = 0;

	if (m_channels == 2){
// Stereo
		// left
		for (size_t i=0; i<size; i+=2){
			in = buffer[i];
			out = (b0 * in + b1 * xn1 + b2 * xn2 - a1 * yn1 - a2 * yn2) / a0;
			xn2 = xn1;
			xn1 = in;
			yn2 = yn1;
			yn1 = out;

//			out += in;
			if (out < -1.0)
				out = -1.0;
			else if (out > 1.0)
				out = 1.0;        //Prevents clipping

			buffer[i] = out;
		}
		// right
		for (size_t i=1; i<size; i+=2){
			in = buffer[i];
			out = (b0 * in + b1 * xn3 + b2 * xn4 - a1 * yn3 - a2 * yn4) / a0;
			xn4 = xn3;
			xn3 = in;
			yn4 = yn3;
			yn3 = out;

//			out += in;
			if (out < -1.0)
				out = -1.0;
			else if (out > 1.0)
				out = 1.0;        //Prevents clipping

			buffer[i] = out;
		}
	}else if (m_channels ==1 ){
// Mono	
		for (size_t i=0; i<size; i++){
			in = buffer[i];
			out = (b0 * in + b1 * xn1 + b2 * xn2 - a1 * yn1 - a2 * yn2) / a0;
			xn2 = xn1;
			xn1 = in;
			yn2 = yn1;
			yn1 = out;

			if (out < -1.0)
				out = -1.0;
			else if (out > 1.0)
				out = 1.0;        //Prevents clipping

			buffer[i] = out;
		}
	}
}
