#ifndef BASS_BOOST_FILTER_H
#define BASS_BOOST_FILTER_H

class BassBoostFilter : public RealtimeFilter {
  public:
	BassBoostFilter(bool r = true);
	virtual bool InitFilter(float f, int32 channels = 2, int32 pass = 0, int32 size = 0);
	virtual void DeAllocate();
	virtual void FilterBuffer(float *, size_t);
	virtual void UpdateValues();

	virtual BView *ConfigView();
   
  private:
	float *delay_buffer;
	int32 buffer_size, pBuffer;
	SpinSlider *freq, *boost;
	float xn1, xn2, yn1, yn2;
	float xn3, xn4, yn3, yn4;
};

#endif
