#include <Window.h>
#include <View.h>
#include <InterfaceKit.h>
#include <stdlib.h>
#include <stdio.h>

#include "Globals.h"
#include "RealtimeFilter.h"
#include "DelayFilter.h"

/*******************************************************
*   
*******************************************************/
DelayWindow::DelayWindow(bool b) : RealtimeFilter(Language.get("DELAY"), b)
{

}

/*******************************************************
*   
*******************************************************/
BView *DelayWindow::ConfigView()
{
	BRect r(0,0,200,100);

	BView *view = new BView(r, NULL, B_FOLLOW_ALL, B_WILL_DRAW);
	view->SetViewColor(ui_color(B_PANEL_BACKGROUND_COLOR));

	r.InsetBy(8,8);
	r.bottom = r.top + 23;
	delay = new SpinSlider(r, NULL, Language.get("DELAY_MS"), new BMessage(CONTROL_CHANGED), 1, 500);
	delay->SetValue(Prefs.filter_delay_delay * 1000);
	view->AddChild(delay);

	r.OffsetBy(0,40);
	gain = new SpinSlider(r, NULL, Language.get("GAIN"), new BMessage(CONTROL_CHANGED), 1, 200);
	gain->SetValue(Prefs.filter_delay_gain * 100);
	view->AddChild(gain);

	return view;
}

void DelayWindow::UpdateValues()
{
	Prefs.filter_delay_delay = delay->Value()/1000.0;
	Prefs.filter_delay_gain = gain->Value()/100.0;

	for (int32 i=0; i<buffer_size; i++)
		delay_buffer[i] = 0;
}

/*******************************************************
*   Init & exit
*******************************************************/
bool DelayWindow::InitFilter(float f, int32 c, int32 pass, int32 size)
{
	RealtimeFilter::InitFilter(f, c, pass, size);

	buffer_size = (int32)m_frequency * m_channels;
	
	delay_buffer = new float[ buffer_size ];
	for (int32 i=0; i<buffer_size; i++)	
		delay_buffer[i] = 0.0;

	pBuffer = buffer_size-m_channels;
	return true;
}

void DelayWindow::DeAllocate()
{
	delete[] delay_buffer;
}

/*******************************************************
*   
*******************************************************/
void DelayWindow::FilterBuffer(float *buffer, size_t size)
{
	float left = 0, right = 0;
	int32 delay = (int32)(m_frequency*Prefs.filter_delay_delay*m_channels);

	if (m_channels == 2){
// Stereo
		for (size_t i=0; i<size; i+=2){

			left = MIN(buffer[i+0] + delay_buffer[ (pBuffer-delay) % buffer_size ] * Prefs.filter_delay_gain, 1);
			right = MIN(buffer[i+1] + delay_buffer[ (pBuffer-delay+1) % buffer_size ] * Prefs.filter_delay_gain, 1);

			delay_buffer[ pBuffer % buffer_size   ] = buffer[i+0];
			delay_buffer[ (pBuffer+1) % buffer_size] = buffer[i+1];
			buffer[i+0] = left;
			buffer[i+1] = right;

			pBuffer += 2;
		}
	}else if (m_channels ==1 ){
// Mono	
		for (size_t i=0; i<size; i++){

			left = MIN(buffer[i] + delay_buffer[ (pBuffer-delay) % buffer_size ] * Prefs.filter_delay_gain, 1);

			delay_buffer[ pBuffer % buffer_size   ] = buffer[i];
			buffer[i] = left;

			pBuffer ++;
		}
	}
}
