/*******************************************************
*   Sample Studio
*   
*   @author  Frans van Nispen (xlr8@tref.nl)
*   @date    16-05-2002
*
*******************************************************/

#ifndef _FILTER_H
#define _FILTER_H
#include "RealtimeFilter.h"

#define FILTER_MONO 	0x01
#define FILTER_STEREO	0x02
#define FILTER_BOTH		0x03
#define FILTER_REALTIME	0x04
#define FILTER_GUI		0x08

typedef struct filter_info
{
	char *name;
	int32 type;
	int32 passes;

} filter_info;

void FiltersInit();
void RunFilter(int32 filter);
void RunFilter(const char *tag);
void ExecuteFilter(RealtimeFilter *filter);
void CancelFilter(RealtimeFilter *filter);
void RunLastFilter();

void DoTrim();
void DoResample();
void ZeroLL();
void ZeroLR();
void ZeroRL();
void ZeroRR();


//===================== Realtime Filter classes without GUI

class SwapFilter : public RealtimeFilter {
  public:
	SwapFilter();
	virtual void FilterBuffer(float *, size_t);
};

class InvertFilter : public RealtimeFilter {
  public:
	InvertFilter();
	virtual void FilterBuffer(float *, size_t);
};

class SilenceFilter : public RealtimeFilter {
  public:
	SilenceFilter();
	virtual void FilterBuffer(float *, size_t);
};

class FadeInFilter : public RealtimeFilter {
  public:
	FadeInFilter();
	virtual void FilterBuffer(float *, size_t);
	virtual bool InitFilter(float f, int32 channels = 2, int32 pass = 0, int32 size = 0);
  private:
	int32 count;
};

class FadeOutFilter : public RealtimeFilter {
  public:
	FadeOutFilter();
	virtual void FilterBuffer(float *, size_t);
	virtual bool InitFilter(float f, int32 channels = 2, int32 pass = 0, int32 size = 0);
  private:
	int32 count;
};



#endif
