#include <Window.h>
#include <View.h>
#include <InterfaceKit.h>
#include <stdlib.h>
#include <stdio.h>

#include "Globals.h"
#include "RealtimeFilter.h"
#include "AmplifierFilter.h"

/*******************************************************
*   
*******************************************************/
AmplifierFilter::AmplifierFilter(bool b) : RealtimeFilter(Language.get("AMPLIFIER"), b)
{

}

/*******************************************************
*   
*******************************************************/
BView *AmplifierFilter::ConfigView()
{
	BRect r(0,0,200,100);

	BView *view = new BView(r, NULL, B_FOLLOW_ALL, B_WILL_DRAW);
	view->SetViewColor(ui_color(B_PANEL_BACKGROUND_COLOR));

	r.InsetBy(8,8);
	r.bottom = r.top + 23;
	value = new SpinSlider(r, NULL, Language.get("LEVEL"), new BMessage(CONTROL_CHANGED), 0, 100);
	value->SetValue(Prefs.filter_limiter_value);
	view->AddChild(value);

	r.OffsetBy(0,40);
	mix = new SpinSlider(r, NULL, Language.get("MIX_LEVEL"), new BMessage(CONTROL_CHANGED), 0, 100);
	mix->SetValue(Prefs.filter_limiter_mix);
	view->AddChild(mix);

	return view;
}

void AmplifierFilter::UpdateValues()
{
	Prefs.filter_limiter_value = value->Value();
	Prefs.filter_limiter_mix = mix->Value();
}

/*******************************************************
*   Init & exit
*******************************************************/
bool AmplifierFilter::InitFilter(float f, int32 c)
{
	RealtimeFilter::InitFilter(f, c);

	old_left = old_right = 0;
/*
	buffer_size = (int32)m_frequency * m_channels;
	
	delay_buffer = new float[ buffer_size ];
	for (int32 i=0; i<buffer_size; i++)	
		delay_buffer[i] = 0.0;

	pBuffer = buffer_size-m_channels;
*/
	return true;
}

void AmplifierFilter::DeAllocate()
{
//	delete[] delay_buffer;
}

/*******************************************************
*   
*******************************************************/
void AmplifierFilter::FilterBuffer(float *buffer, size_t size)
{
	float tmp, tmp2, lim;
	float mix = Prefs.filter_limiter_mix/100.0;
	float mix2 = 1-mix;
	float value = Prefs.filter_limiter_value/1000.0;

	if (m_channels == 2){
// Stereo
		// left
		for (size_t i=0; i<size; i+=2){
			tmp = buffer[i];
			lim = tmp - old_left;
			old_left = tmp;

			if (lim > 0)
			{
				if (lim >= value)
				{
					tmp += value;
				}
			}
			if (lim < 0)
			{
				lim = -lim;
				if (lim >= value)
				{
					tmp -= value;
				}
			}

			if (tmp > 1)		tmp = 1;
			else if (tmp<-1)	tmp = -1;
			
			buffer[i] = mix2*buffer[i] + mix*tmp;
		}
		// right
		for (size_t i=1; i<size; i+=2){
			tmp = buffer[i];
			lim = tmp - old_right;
			old_right = tmp;

			if (lim > 0)
			{
				if (lim >= value)
				{
					tmp += value;
				}
			}
			if (lim < 0)
			{
				lim = -lim;
				if (lim >= value)
				{
					tmp -= value;
				}
			}

			if (tmp > 1)		tmp = 1;
			else if (tmp<-1)	tmp = -1;
			
			buffer[i] = mix2*buffer[i] + mix*tmp;
		}
	}else if (m_channels ==1 ){
// Mono	
		for (size_t i=0; i<size; i++){
			tmp = buffer[i];
			lim = old_left - tmp;
			old_left = tmp;

			if (lim > 0)
			{
				if (lim >= value)
				{
					tmp += value;
				}
			}
			if (lim < 0)
			{
				lim = -lim;
				if (lim >= value)
				{
					tmp -= value;
				}
			}

			if (tmp > 1)		tmp = 1;
			else if (tmp<-1)	tmp = -1;
			
			buffer[i] = mix2*buffer[i] + mix*tmp;
		}
	}
}
