#ifndef AMP_FILTER_H
#define AMP_FILTER_H

class LimiterFilter : public RealtimeFilter {
  public:
	LimiterFilter(bool r = true);
	virtual bool InitFilter(float f, int32 channels = 2);
	virtual void DeAllocate();
	virtual void FilterBuffer(float *, size_t);
	virtual void UpdateValues();

	virtual BView *ConfigView();
   
  private:
	float *delay_buffer;
	float old_left, old_right;
	int32 buffer_size, pBuffer;
	SpinSlider *value, *mix;
};

#endif
