#ifndef CLEAN_FILTER_H
#define CLEAN_FILTER_H

class CleanWindow : public RealtimeFilter {
  public:
	CleanWindow(bool r = true);
	virtual bool InitFilter(float f, int32 channels = 2, int32 pass = 0, int32 size = 0);
	virtual void DeAllocate();
	virtual void FilterBuffer(float *, size_t);
	virtual void UpdateValues();

	virtual BView *ConfigView();
   
  private:
	float *delay_buffer;
	int32 pBuffer;
	float left_gain, right_gain;
	SpinSlider *delay, *gain, *damping;
	
	int32 samples, treshold;
};

#endif
