#ifndef COMPRESS_FILTER_H
#define COMPRESS_FILTER_H

class CompressorFilter : public RealtimeFilter {
  public:
	CompressorFilter(bool r = true);
	virtual bool InitFilter(float f, int32 channels = 2, int32 pass = 0, int32 size = 0);
	virtual void DeAllocate();
	virtual void FilterBuffer(float *, size_t);
	virtual void UpdateValues();

	virtual BView *ConfigView();
   
  private:
	float *delay_buffer;
	float mRMSSumL, mMultL, mDecayMult;
	float mRMSSumR, mMultR;
	float mThreshold, mGain, mInvRatio;
	int32 buffer_size, pBuffer;
	SpinSlider *attac, *decay, *ratio, *gain, *treshold;
	BCheckBox *rms;
};

#endif
