/*******************************************************
*   There are the standerd mesagess that get passed 
*   around by Sample Studio.
*
*   
*******************************************************/
#ifndef GLOBALS_H
#define GLOBALS_H

#include "CommonPool.h"
#include "CommonClass.h"
#include "YLanguageClass.h"
#include "Preferences.h"
#include "History.h"
#include "MouseIcons.h"

#define INT_MUL(a,b,t)				((t) = (a) * (b) + 0x80, ((((t) >> 8) + (t)) >> 8))
#define INT_MUL3(a,b,c,t)			((t) = (a) * (b) * (c)+ 0x7F5B, ((((t) >> 7) + (t)) >> 16))
#define INT_BLEND(a,b,alpha,tmp)	(INT_MUL((a)-(b), alpha, tmp) + (b))
#define WITHIN(a, b, c)				((((a) <= (b)) && ((b) <= (c))) ? 1 : 0)
#define ROUND(a)					(( ( (a)-long((a)) ) >=.5 ) ? (long((a))+1) : long((a)))
#define CLAMP(a, b, c)				( (a) = (a)<(b) ? (b) : (  (a)>(c) ? (c) : (a) ) )

#ifndef PI
	#define PI 3.14159265358979323846
#endif

// The thread names
#define TOOL_TIP_WINDOW		"Help System"

#define MIN_W 	530
#define MIN_H	256
#define MAX_W 	2048
#define MAX_H	1536

#define TIMEBAR_HEIGHT		16
#define VALUEBAR_WIDTH		32
#define INDEXVIEW_HEIGHT	20	//POINTER_BAR_HEIGHT +24	//+32

#define COPY_RIGHT "SampleStudio Copyright 2002 Xentronix"

// This is our offical Ver description Build data/time is built into about box
#define VERSION                "Alpha"

// The directory off of /boot/home/settings that we look for Inferno settings
#define SETTINGS_DIR           "SampleStudio"

// Current directory that Inferno pulls plugins from
#define FILTERS_DIR             "Plug-Ins/Filters"

// Mime type for IDF files
#define DOCUMENT_MIME   "image/x-SampleStudio"


enum {NONE=0, LEFT, RIGHT, BOTH};
enum {SAMPLES, TIME};
enum {PLAY=1, RECORD, PLAY_PAUSE, RECORD_PAUSE};
enum {MONO=1, STEREO=2};

#define POINTER_BAR_HEIGHT	12

#define SPLITTER			'sltr'	// used to separate key-bind catagories
#define SAVE_AS   			'ssam'
#define NEW					'Bnew'
#define OPEN				'Bopn'
#define DO_OPEN				'Dopn'
#define SAVE				'Bsav'
#define SAVE_SELECTION		'Bsva'
#define INSERT				'Bins'
#define APPEND				'apnd'
#define UNDO				'undo'
#define UNDO_ENABLE			'undE'
#define REDO				'redo'
#define PASTE_MIXED			'pmix'
#define PASTE_NEW			'pnew'
#define DROP_PASTE			'drpP'
#define TO_STACK			'2stk'
#define SET_LOOP			'stlp'
#define PREFERENCES			'pref'
#define OPEN_MIX			'opnM'
#define HELP				'help'
#define ABOUT				'bout'
#define HOMEPAGE			'hmep'
#define TUTORIALS			'tuts'

#define ZERO_IN				'zrIn'
#define ZERO_OUT			'zrOt'
#define ZERO_LL				'zrLL'
#define ZERO_LR				'zrLR'
#define ZERO_RL				'zrRL'
#define ZERO_RR				'zrRR'
#define TRIM				'trim'
#define SET_FREQUENCY		'setF'
#define RESAMPLE			'rspl'
#define RESAMPLE_DO			'rspD'
#define CLEAR				'clrD'
#define UNSELECT_ALL		'usel'
#define COPY_SILENCE		'cpyS'

#define EDIT_L				'EdiL'
#define EDIT_R				'EdiR'
#define EDIT_B				'EdiB'

#define TRANSPORT_REW		'Trew'
#define TRANSPORT_REW_ALL	'Trwa'
#define TRANSPORT_FWD		'Tfwd'
#define TRANSPORT_FWD_ALL	'Tfwa'
#define TRANSPORT_PLAY		'Tply'
#define TRANSPORT_STOP		'Tstp'
#define TRANSPORT_REC		'Trec'
#define TRANSPORT_PAUSE		'Tpse'
#define TRANSPORT_PAUSE_MAN	'TpsM'	// needed for keybindings
#define TRANSPORT_PLAYS		'Tpls'
#define TRANSPORT_LOOP		'Tlop'
#define TRANSPORT_LOOP_MAN	'TlpM'
#define TRANSPORT_HOME		'Tlhm'
#define TRANSPORT_END		'Tled'
#define TRANSPORT_LEFT		'Tllf'
#define TRANSPORT_RIGHT		'Tlrg'
#define TRANSPORT_TOGGLE	'Tltg'
#define TRANSPORT_SET		'Tlst'

#define ZOOM_IN				'zmIn'
#define ZOOM_OUT			'zmOt'
#define ZOOM_FULL			'zmFl'
#define ZOOM_SELECTION		'zmSl'
#define ZOOM_LEFT			'zmLf'
#define ZOOM_RIGHT			'zmRg'

#define RUN_FILTER			'FXrn'
#define RUN_FILTER_KEY		'FXky'
#define EXE_FILTER			'FXex'
#define CANCEL_FILTER		'FXcl'
#define RUN_LAST_FILTER		'FXlt'

#define TOOL_SELECT			'Tsel'
#define TOOL_DRAW			'Tdrw'
#define TOOL_PLAY			'TLpl'
#define TOOL_JOGG			'Tsrb'

#define SPECTRUM			'spct'
#define SAMPLE_SCOPE		'spls'
#define PLASMA_SCOPE		'sppl'

#define CHANGE_LANGUAGE		'chgL'
#define SET_TIME			'setT'

#define UPDATE_MENU			'_udm'
#define REDRAW				'rdrw'

#endif
