#ifndef MY_STRING_ITEM_H
#define MY_STRING_ITEM_H

#include <ListItem.h>
#include <View.h>
#include "MyStringItem.h"

StringItem::StringItem(const char *label, int32 level, bool expanded)
	: BListItem(level, expanded)
{
	m_label = new char[strlen(label)+1];
	strcpy(m_label, label);
}

StringItem::~StringItem()
{
	if (m_label)
		delete[] m_label;
}

const char *StringItem::Label() const
{
	return m_label;
}

void StringItem::DrawItem(BView *view, BRect rect, bool all)
{
	BFont font;
	view->GetFont(&font);

	if (IsSelected())
		view->SetLowColor(150,190,230);
	else
		view->SetLowColor(255,255,255);

	view->FillRect(rect, B_SOLID_LOW);
	view->SetHighColor(0,0,0);
	view->DrawString( m_label, BPoint( rect.left +5, rect.top +font.Size() ));

}

#endif
