#include <Window.h>
#include <stdio.h>

#include "Globals.h"
#include "PrefWindow.h"
#include "PrefView.h"
#include "Shortcut.h"

#define COLOR_SELECT		'colS'

/*******************************************************
*
*******************************************************/
PrefWindow::PrefWindow():BWindow(BRect(100,100,600,450),
	Language.get("PREFS"), B_TITLED_WINDOW, B_ASYNCHRONOUS_CONTROLS|B_NOT_RESIZABLE|B_NOT_ZOOMABLE)
{
	AddChild(new PrefView(Bounds()));
	Run();
}

/*******************************************************
*
*******************************************************/
bool PrefWindow::QuitRequested(){
   Hide();
   return false;
}

/*******************************************************
*
*******************************************************/
void PrefWindow::MessageReceived(BMessage *message){
	BView *tmpV;
	int32 k;

	switch (message->what){
	case QUIT:
		Hide();
		break;
	
	case CHANGE_LANGUAGE:
		tmpV = ChildAt(0);
		if (tmpV != NULL){
			tmpV->RemoveSelf();
			delete tmpV;
		}
		AddChild(new PrefView(Bounds()));
		break;
	
	case SET_FACTORY:
		k = (new BAlert(NULL,Language.get("FACTORY_SURE"),Language.get("APPLY"),Language.get("CANCEL")))->Go();
		if (k==0){
			Prefs.FactorySettings();
			KeyBind.InstallDefaults();
			tmpV = FindView("Prefs color");
			if (tmpV != NULL){
				PostMessage(COLOR_SELECT, tmpV);
			}
			tmpV = FindView("Prefs keys");
			if (tmpV != NULL){
				tmpV->LockLooper();
				tmpV->Pulse();
				tmpV->UnlockLooper();
			}else{
				be_app->PostMessage(CHANGE_LANGUAGE);
			}
			Pool.sample_view_dirty = true;	// update the sample-view
			Pool.update_draw_cache = true;	// update the draw cache
			Pool.update_index = true;		// update the index cache
			Pool.RedrawWindow();
		}
		break;

	default:
		BWindow::MessageReceived(message);
	}
}
