/*******************************************************
*   Sample Studio
*   
*   @author  Frans van Nispen (xlr8@tref.nl)
*   @date    29-07--2001
*
*******************************************************/

#ifndef _Sample_VIEW
#define _Sample_VIEW
#include <View.h>
#include <Bitmap.h>

// peak: from peakfile
// plain: lines, editable
// points: draggable points
enum {DRAW_PEAK, DRAW_PLAIN, DRAW_POINTS };

class SampleView: public BView{
 public:
	SampleView(BRect r);
	virtual ~SampleView();
	virtual void AttachedToWindow();
	virtual void Draw(BRect);
	virtual void MouseDown(BPoint);
	virtual void MouseUp(BPoint);
	virtual void MouseMoved(BPoint, uint32, const BMessage *);
	virtual void Pulse();
	virtual void FrameResized(float width, float height);
	
	void EditPoint(BPoint p);
	void EditLine(BPoint, BPoint);
	void DoDraw(int64 ptr, int32 add, float v);
	
	void Init();

 private:
 	void CalculateCache();
 	void DrawMono(BRect, bool left, bool draw_selection);
 	void DrawStereo(BRect);
	void DrawPart(	rgb_color *inBits, rgb_color *outBits,
					rgb_color col, float *peak_buffer,
					BRect r, int32 size, int32 size2);

 	BBitmap *OffScreen;
 	BBitmap *leftCache, *rightCache, *leftSelected, *rightSelected;
	BPoint old, start_selection;
 	
 	rgb_color *leftBits, *leftSelectedBits;
 	rgb_color *rightBits, *rightSelectedBits;
 	rgb_color *screenBits;

 	int32 leftWidth, rightWidth, screenWidth;
	int32 edit_channel;

 	int64 pointer, m_old_l_pointer, m_old_r_pointer;
	int64 t, t2;

 	float old_x;
	float m_width;
	float old_v;
	float *peak_buffer_l;
	float *peak_buffer_r;

	bool drag, edit, stop_following, draw_selection;
	bool drag_border, drag_selection;
 	bool m_resized, cache_left_valid, cache_right_valid;
 	
	sem_id viewSem;
};

#endif



