// Based upon YNOP's InfernoShortCut Class
#ifndef SHORTCUT_H
#define SHORTCUT_H

#include <AppKit.h>
#include <map>
#include <string.h>

struct key_bind{
	const char *ID;		// lookup ID (TAG that can be converted by Language.get()
	char key;			// the key
	int32 mod;			// its modifyers
	char keyAlt;		// the 2nd key
	int32 modAlt;		// its 2nd modifyers
	uint32 message;		// Message to be posted to the window
	bool menuItem;		// is a menu item ??? Has to have B_COMMAND_KEY
};

class Shortcut{
  public:
	Shortcut();
	~Shortcut();
   
	// called by system
	void Init();
   
	// request the ID for a binding
	char *GetID(int32 i) const;
	char *GetID(char key, int32 mod) const;
	
	// number of bindings
	int32 CountBindings() const;

	// Gets the key that linked to this
	// spesifier. If no match then 0 is
	// returned
	char GetKey(const char *ID);
	char GetKeyAlt(const char *ID);
	
	// returns wether it is a menu item
	bool IsMenuItem(const char *ID);
   
	// Gets the mod that is linked to this
	// spesifier. if no match then 0 is
	// returned
	int32 GetMod(const char *ID);
	int32 GetModAlt(const char *ID);
   
	// Gets the message 'what' that is linked to this
	// spesifier. if no match then 0 is
	// returned
	uint32 GetMessage(const char *ID);
	uint32 GetMessage(char key, int32 mod);

	// checks to see if a key is installed
	// although this is not needed as install
	// auto checks this for you.
	bool IsInstalled(const char *ID);
   
	// Installs a new Spesifier with a pritty name
	// if that spesifier alreay exists it does 
	// nothing.
	void Install(bool menu, const char *ID, char key, int32 mod, char keyAlt, int32 modAlt, uint32 message);
	
	void InstallDefaults();
   
  private:
	key_bind* FindKB(const char *ID);

	BList kbind;
	key_bind *lastkb;
};
extern Shortcut KeyBind; // Included so you don't have too
#endif








