//
// AccelRegs.h
//	A part of SiS6326 driver for BeOS
//	Copyright (C) 2000 Yasutaka Uematu All rights reserved.
//	yasutaka2000@bemail.org
//

#ifndef	_ACCELREGS_H_
#define	_ACCELREGS_H_

#include "GlobalData.h"	// regs

#define	ACC_SRCSTART		*(regs + 0x8280/sizeof(vuint32))
#define	ACC_DSTSTART		*(regs + 0x8284/sizeof(vuint32))
#define	ACC_SRCPITCH		*(vuint16 *)((vuint16 *)regs + 0x8288/sizeof(vuint16))
#define	ACC_DSTPITCH		*(vuint16 *)((vuint16 *)regs + 0x828a/sizeof(vuint16))
#define	ACC_RECTWIDTH		*(vuint16 *)((vuint16 *)regs + 0x828c/sizeof(vuint16))
#define	ACC_RECTHEIGHT		*(vuint16 *)((vuint16 *)regs + 0x828e/sizeof(vuint16))
#define	ACC_FGCOLOR8		*(vuint8 *)((vuint8 *)regs + 0x8290)
#define	ACC_FGCOLOR16		*(vuint16 *)((vuint16 *)regs + 0x8290/sizeof(vuint16))
#define	ACC_FGROP			*(vuint8 *)((vuint8 *)regs + 0x8293)
#define	ACC_BGROP			*(vuint8 *)((vuint8 *)regs + 0x8297)

#define	ACC_CMDQUESTAT		*(vuint16 *)((vuint16 *)regs + 0x82a8/sizeof(vuint16))
#define	ACC_CMD			*(vuint16 *)((vuint16 *)regs + 0x82aa/sizeof(vuint16))
#define	ACC_CMD0			*(vuint8 *)((vuint8 *)regs + 0x82aa)
#define	ACC_CMD1			*(vuint8 *)((vuint8 *)regs + 0x82ab)

#endif