/*
	Copyright 1999, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.

	SiS6326 graphics card accelerant
	written by Yasutaka Uematu (yasutaka2000@bemail.org)
*/

#include	<support/Debug.h>

#if __INTEL__
#else
#include	"Swap2Little.h"
#endif

#include "GlobalData.h"
#include "generic.h"
#include	"AccelRegs.h"

//#define STICKY_REGS 1

#if __INTEL__
#define wait_for_slots(numSlots)				\
{										\
	int	theTimeout;						\
										\
	for (theTimeout = 0;					\
		(theTimeout < 32767) && ((ACC_CMDQUESTAT & 0x003f) < numSlots);	\
		theTimeout++) {					\
			;							\
	}									\
	if (theTimeout >= 32767) {				\
		SERIAL_PRINT(("ySiS : Timeout\n"));	\
	}									\
}
#else
// ppc needs swap
#define wait_for_slots(numSlots) 				\
{ 										\
	int	theTimeout; 						\
										\
	for (theTimeout = 0;					\
		(theTimeout < 32767) && ((swap16(ACC_CMDQUESTAT) & 0x003f) < numSlots);	\
		theTimeout++) {					\
			;							\
	}									\
	if (theTimeout >= 32767) {				\
		SERIAL_PRINT(("ySiS : Timeout\n"));	\
	}									\
}
#endif

void hardware_rectangle(engine_token *, uint32, fill_rect_params *, uint32, uint8);

void SCREEN_TO_SCREEN_BLIT(engine_token * et, blit_params *list, uint32 count) {
	uint bpp, scrnwidth;

	uint16	accOper;
	int	startx, starty;
	int	width,height;
	int	destx, desty;
	uint32 startaddr,destaddr;

	
	SERIAL_PRINT(("ySiS : SCREEN_TO_SCREEN_BLIT\n"));	// TEST 001028
	switch (si->dm.space & ~0x3000)
	{
	case B_CMAP8:
		bpp = 1;
		break;
	case B_RGB15_BIG:
	case B_RGBA15_BIG:
	case B_RGB15_LITTLE:
	case B_RGBA15_LITTLE:
		bpp = 2;
		break;
	case B_RGB16_BIG:
	case B_RGB16_LITTLE:
		bpp = 2;
		break;
	default:
		bpp = 1;
	}
	scrnwidth = si->dm.virtual_width;

	/* program the blit */
	while (count--) {
		startx = list->src_left;
		starty = list->src_top;
		destx = list->dest_left;
		desty = list->dest_top;

		width = list->width + 1;
		height = list->height + 1;

		accOper = 0x0002;
		if (starty > desty) {
			accOper |= 0x0020;
			if (startx > destx) {
		     		accOper |= 0x0010;
				startaddr = (starty * scrnwidth + startx) * bpp;
				destaddr = (desty * scrnwidth + destx) * bpp;
		     }else{
		     		startaddr = (starty * scrnwidth + startx + width) * bpp - 1;
		     		destaddr = (desty * scrnwidth + destx + width) * bpp - 1;
			}
		}else{
			if (startx > destx) {
				accOper |= 0x0010;
				startaddr = ((starty + height - 1) * scrnwidth + startx) * bpp;
				destaddr = ((desty + height - 1) * scrnwidth + destx) * bpp;
			}else{
				startaddr = ((starty + height - 1) * scrnwidth + startx + width) * bpp - 1;
				destaddr = ((desty + height - 1) * scrnwidth + destx + width) * bpp - 1;
			}
		}

		// Set up the rectangle blit

		// Critital section - accessing card registers.
		//lock_card();
		wait_for_slots(10);		// Bitbltはキューを10要素消費する。
		
		ACC_FGROP = 0xcc;
		ACC_BGROP = 0xcc;
#if __INTEL__
		ACC_SRCSTART = startaddr;
		ACC_DSTSTART = destaddr;
		ACC_RECTWIDTH = (width * bpp) - 1;
		ACC_RECTHEIGHT = height - 1;
		ACC_SRCPITCH = scrnwidth * bpp;
		ACC_DSTPITCH = scrnwidth * bpp;
		ACC_CMD = accOper;
#else
		ACC_SRCSTART = swap32(startaddr);
		ACC_DSTSTART = swap32(destaddr);
		ACC_RECTWIDTH = swap16((uint16)((width * bpp) - 1));
		ACC_RECTHEIGHT = swap16((uint16)(height - 1));
		ACC_SRCPITCH = swap16((uint16)(scrnwidth * bpp));
		ACC_DSTPITCH = swap16((uint16)(scrnwidth * bpp));
		ACC_CMD = swap16(accOper);
#endif
		/* next one */
		list++;

	}
}

void hardware_rectangle(engine_token *et
					, uint32 colorIndex
					, fill_rect_params *list
					, uint32 count
					, uint8 ROP) {
	uint bpp, scrnwidth;

	uint16	accOper;
	int	width,height;
	int	destx, desty;
	uint32 destaddr;

	SERIAL_PRINT(("ySiS : enter hardware_rectangle\n"));
	switch (si->dm.space & ~0x3000)
	{
	case B_CMAP8:
		bpp = 1;
		break;
	case B_RGB15_BIG:
	case B_RGBA15_BIG:
	case B_RGB15_LITTLE:
	case B_RGBA15_LITTLE:
		bpp = 2;
		break;
	case B_RGB16_BIG:
	case B_RGB16_LITTLE:
		bpp = 2;
		break;
	default:
		bpp = 1;
	}
	scrnwidth = si->dm.virtual_width;

	/* program the blit */
	while (count--) {
		destx = list->left;
		desty = list->top;

		width = list->right - list->left + 1;
		height = list->bottom - list->top + 1;
		destaddr = (desty * scrnwidth + destx) * bpp;

		accOper = 0x0031;
		// Set up the rectangle blit

		// Critital section - accessing card registers.
		//lock_card();
		wait_for_slots(10);		// Bitbltはキューを10要素消費する。
		
		ACC_FGROP = ROP;
#if __INTEL__
		ACC_DSTSTART = destaddr;
		ACC_RECTWIDTH = (width * bpp) - 1;
		ACC_RECTHEIGHT = height - 1;
		if (bpp == 1) {
			ACC_FGCOLOR8 = (vuint8)colorIndex;
		}else{
			ACC_FGCOLOR16 = (vuint16)(colorIndex & 0xffff);
		}
		ACC_DSTPITCH = scrnwidth * bpp;
		ACC_CMD = accOper;
#else
		ACC_DSTSTART = swap32(destaddr);
		ACC_RECTWIDTH = swap16((uint16)((width * bpp) - 1));
		ACC_RECTHEIGHT = swap16((uint16)(height - 1));
		if (bpp == 1) {
			ACC_FGCOLOR8 = (vuint8)colorIndex;
		}else{
			ACC_FGCOLOR16 = (vuint16)(colorIndex & 0xffff);
		}
		ACC_DSTPITCH = swap16((uint16)(scrnwidth * bpp));
		ACC_CMD = swap16(accOper);
#endif
		/* next one */
		list++;

	}
//	SERIAL_PRINT(("ySiS : leave hardware_rectangle\n"));	// TEST 001028
}

void FILL_RECTANGLE(engine_token *et, uint32 colorIndex, fill_rect_params *list, uint32 count) {
	// 驚くべきことに、画面表示のかなりの部分をこの機能に依存している。
	// これが速ければ速いほど画面表示は速くなるといっても過言ではない。
	hardware_rectangle(et, colorIndex, list, count, 0xCC); // ROP = SRC
}

void INVERT_RECTANGLE(engine_token *et, fill_rect_params *list, uint32 count) {
	// これは、Trackerでファイル名を反転させたり、BeIMで入力中の文字をアミ掛けしたりするのに
	// 使われる。なおざりにして良い関数ではない。
	hardware_rectangle(et, 0xFFFFFFFF, list, count, 0x55); // ROP = !DST
}

void FILL_SPAN(engine_token *et, uint32 colorIndex, uint16 *list, uint32 count) {
	uint		bpp, scrnwidth;

	uint16	accOper;
	uint32	width,height;
	uint32	destx, desty;
	uint32	destaddr;

	SERIAL_PRINT(("ySiS : FILL_SPAN(count = %d)\n", count));

	switch (si->dm.space & ~0x3000)
	{
	case B_CMAP8:
		bpp = 1;
		break;
	case B_RGB15_BIG:
	case B_RGBA15_BIG:
	case B_RGB15_LITTLE:
	case B_RGBA15_LITTLE:
		bpp = 2;
		break;
	case B_RGB16_BIG:
	case B_RGB16_LITTLE:
		bpp = 2;
		break;
	default:
		bpp = 1;
	}
	scrnwidth = si->dm.virtual_width;
	
	/* program the blit */
	while (count--) {
		desty = (uint32)*list++;
		destx = (uint32)*list++;
		width = (uint32)*list++;

		width = width - destx + 1;

		height = 1;
		destaddr = (desty * scrnwidth + destx) * bpp;

		accOper = 0x0031;
		// Set up the rectangle blit

		// Critital section - accessing card registers.
		//lock_card();
		wait_for_slots(10);		// Bitbltはキューを10要素消費する。
		
		ACC_FGROP = 0xCC;
#if __INTEL__
		ACC_DSTSTART = destaddr;
		ACC_RECTWIDTH = (width * bpp) - 1;
		ACC_RECTHEIGHT = height - 1;
		if (bpp == 1) {
			ACC_FGCOLOR8 = (vuint8)colorIndex;
		}else{
			ACC_FGCOLOR16 = (vuint16)(colorIndex & 0xffff);
		}
		ACC_DSTPITCH = scrnwidth * bpp;
		ACC_CMD = accOper;
#else
		ACC_DSTSTART = swap32(destaddr);
		ACC_RECTWIDTH = swap16((uint16)((width * bpp) - 1));
		ACC_RECTHEIGHT = swap16((uint16)(height - 1));
		if (bpp == 1) {
			ACC_FGCOLOR8 = (vuint8)colorIndex;
		}else{
			ACC_FGCOLOR16 = (vuint16)(colorIndex & 0xffff);
		}
		ACC_DSTPITCH = swap16((uint16)(scrnwidth * bpp));
		ACC_CMD = swap16(accOper);
#endif		
	}
}
