/*
	Copyright 1999, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.

	SiS6326 graphics card accelerant
	written by Yasutaka Uematu (yasutaka2000@bemail.org)
*/

#include	<support/Debug.h>
#include	<string.h>

#include	"GlobalData.h"
#include	"generic.h"
#include	"SiSaccelData.h"
#include	"SiSaccelutil.h"
#include	"IOaccess.h"

void set_cursor_colors(void);	// prototype

void set_cursor_colors(void) {
	SERIAL_PRINT(("ySiS : set_cursor_colors\n"));	// TEST 001028
	/* a place-holder for a routine to set the cursor colors */
	/* In our sample driver, it's only called by the INIT_ACCELERANT() */
	// Color-0 : 白
	gSEQR.s.fSR14.HCC0red = 0x3f;
	gSEQR.s.fSR15.HCC0green = 0x3f;
	gSEQR.s.fSR16.HCC0blue = 0x3f;	
	SeqOut(0x14, gSEQR.fValue[0x14]);
	SeqOut(0x15, gSEQR.fValue[0x15]);
	SeqOut(0x16, gSEQR.fValue[0x16]);

	// Color-1 : 黒
	gSEQR.s.fSR17.HCC1red = 0x0;
	gSEQR.s.fSR18.HCC1green = 0x0;
	gSEQR.s.fSR19.HCC1blue = 0x0;
	SeqOut(0x17, gSEQR.fValue[0x17]);
	SeqOut(0x18, gSEQR.fValue[0x18]);
	SeqOut(0x19, gSEQR.fValue[0x19]);

	
}

status_t SET_CURSOR_SHAPE(uint16 width, uint16 height, uint16 hot_x, uint16 hot_y, uint8 *andMask, uint8 *xorMask) {

	SERIAL_PRINT(("ySiS : enter SET_CURSOR_SHAPE\n"));	// TEST 001028

	/* NOTE: Currently, for BeOS, cursor width and height must be equal to 16. */
	if ((width != 16) || (height != 16))
	{
		return B_ERROR;
	}
	else if ((hot_x >= width) || (hot_y >= height))
	{
		return B_ERROR;
	}
	else
	{
		/*
		Different cards have different cursor configuration requirements, so you're
		on your own.
		*/
		// SiS6326のH/W Cursorのサイズは64x64。
		// もっとも表示バッファを使用するモード(1600x1200,16bpp)でもメモリの使用量は3750KB。
		// そのため、H/WCursorのイメージバッファには4MB直前の領域(0x003fc000)を割り当てる。
		int	theLoopY, theLoopX, theBit;
		uint16	theValue;
		uint8	*theHWCimage;
		
		theHWCimage = (uint8 *)si->cursor.data;

		memset(theHWCimage, 0xaa , 0x400);	// Clear H/W cursor buffer
		for(theLoopY = 0; theLoopY < 16; theLoopY++) {
			for(theLoopX = 0;theLoopX < 2; theLoopX++) {
				theValue = 0;
				for(theBit = 0; theBit < 8;theBit++) {
					theValue |= ((*andMask & (1 << theBit)) << (theBit + 1))
						      | ((*xorMask & (1 << theBit)) << theBit);
				}
				*(theHWCimage + theLoopY * 16 + theLoopX * 2) = (uint8)(theValue >> 8);
				*(theHWCimage + theLoopY * 16 + theLoopX * 2 + 1) = (uint8)(theValue & 0xff);
				andMask++;
				xorMask++;
			}	
		}
		/* Update cursor variables appropriately. */
		si->cursor.width = width;
		si->cursor.height = height;
		si->cursor.hot_x = hot_x;
		si->cursor.hot_y = hot_y;
	}

	return B_OK;
}

/*
Move the cursor to the specified position on the desktop.  If we're
using some kind of virtual desktop, adjust the display start position
accordingly and position the cursor in the proper "virtual" location.
*/
void MOVE_CURSOR(uint16 x, uint16 y) {
	int	thePresetX, thePresetY;

	bool move_screen = false;
	uint16 hds = si->dm.h_display_start;	/* the current horizontal starting pixel */
	uint16 vds = si->dm.v_display_start;	/* the current vertical starting line */

	/*
	Most cards can't set the starting horizontal pixel to anything but a multiple
	of eight.  If your card can, then you can change the adjustment factor here.
	Oftentimes the restriction is mode dependant, so you could be fancier and
	perhaps get smoother horizontal scrolling with more work.  It's a sample driver,
	so we're going to be lazy here.
	*/
	uint16 h_adjust = 7;	/* a mask to make horizontal values a multiple of 8 */

	/* clamp cursor to virtual display */
	if (x >= si->dm.virtual_width) x = (uint16)(si->dm.virtual_width - 1);
	if (y >= si->dm.virtual_height) y = (uint16)(si->dm.virtual_height - 1);

	/* adjust h/v_display_start to move cursor onto screen */
	if (x >= (si->dm.timing.h_display + hds)) {
		hds = (uint16)(((x - si->dm.timing.h_display) + 1 + h_adjust) & ~h_adjust);
		move_screen = true;
	} else if (x < hds) {
		hds = (uint16)(x & ~h_adjust);
		move_screen = true;
	}
	if (y >= (si->dm.timing.v_display + vds)) {
		vds = (uint16)(y - si->dm.timing.v_display + 1);
		move_screen = true;
	} else if (y < vds) {
		vds = y;
		move_screen = true;
	}

	/* reposition the desktop on the display if required */
	if (move_screen) MOVE_DISPLAY(hds,vds);

	/* put cursor in correct physical position */
	x -= hds;
	y -= vds;

	// ySiS : どうも、ここでhot_x, hot_yを考慮してやらないと、カーソルの
	// 操作点とその表示位置がずれてしまい面白くない。
	thePresetX = (int)x - si->cursor.hot_x;
	thePresetY = (int)y - si->cursor.hot_y;
	if (thePresetX >= 0) {
		x -= si->cursor.hot_x;
		thePresetX = 0;
	}else{
		thePresetX = 0 - thePresetX;
		x = 0;
	}
	if (thePresetY >= 0) {
		y -= si->cursor.hot_y;
		thePresetY = 0;
	}else{
		thePresetY = 0 - thePresetY;
		y = 0;
	}

	/* position the cursor on the display */
	/* this will be card dependant */
	gSEQR.s.fSR1A.HCHstart70 = (uint8)(x & 0xff);
	gSEQR.s.fSR1B.HCHstart108 = (x >> 8) & 0x07;
	
	SeqOut(0x1a, gSEQR.fValue[0x1a]);
	SeqOut(0x1b, gSEQR.fValue[0x1b]);

	gSEQR.s.fSR1C.HCHpreset = thePresetX & 0x1f;
	SeqOut(0x1c, gSEQR.fValue[0x1c]);
	
	gSEQR.s.fSR1D.HCVstart70 = (uint8)(y & 0xff);
	gSEQR.s.fSR1E.HCVstart108 = (y >> 8) & 0x07;
	
	SeqOut(0x1d, gSEQR.fValue[0x1d]);
	SeqOut(0x1e, gSEQR.fValue[0x1e]);

	gSEQR.s.fSR1F.HCVpreset = thePresetY & 0x1f;
	SeqOut(0x1f, gSEQR.fValue[0x1f]);
}

void SHOW_CURSOR(bool is_visible) {
	tIOIdxAccess	theSR6;
	
	SERIAL_PRINT(("ySiS : SHOW_CURSOR\n"));	// TEST 001028
	theSR6.fOffset = SEQ_IDX;
	theSR6.fIndex = 0x06;
	(void)ioctl(fd, YSIS_READ_INDEXED, &theSR6);
	gSEQR.fValue[0x06] = theSR6.fValue;	

	if (is_visible)	{
		gSEQR.s.fSR6.GMHCDenable = 1;
	} else {
		gSEQR.s.fSR6.GMHCDenable = 0;
	}
	SeqOut(0x06, gSEQR.fValue[0x06]);
	
	/* record for our info */
	si->cursor.is_visible = is_visible;
}
