//
// FromX.c
//
// These functions are based on XFree86 3.3.6 , 4.0 SiS driver.
// If you have any questions, please ask yasutaka2000@bemail.org, 
// NEVER ask to XFree86 members.
//
// このファイル中の関数はXFree86 3.3.6および4.0のSiS用ドライバを元に作成した。
// このソース中の処理については、yasutaka2000@bemail.orgに問い合わせること。
// けっして、原作者に問い合わせないこと。
//
/*
 * Copyright 1998,1999 by Alan Hourihane, Wigan, England.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Alan Hourihane not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Alan Hourihane makes no representations
 * about the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 * ALAN HOURIHANE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL ALAN HOURIHANE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors:  Alan Hourihane, alanh@fairlite.demon.co.uk
 *           Mike Chapman <mike@paranoia.com>, 
 *           Juanjo Santamarta <santamarta@ctv.es>, 
 *           Mitani Hiroshi <hmitani@drl.mei.co.jp> 
 *           David Thomas <davtom@dream.org.uk>. 
 */

/*
 *	fd = fref*(Numerator/Denumerator)*(Divider/PostScaler)
 *
 *	M 	= Numerator [1:128] 
 *  N 	= DeNumerator [1:32]
 *  VLD	= Divider (Vco Loop Divider) : divide by 1, 2
 *  P	= Post Scaler : divide by 1, 2, 3, 4
 *  PSN     = Pre Scaler (Reference Divisor Select) 
 * 
 */

#include	<SupportDefs.h>
#include	<support/Debug.h>
#include	"SiSaccelData.h"
#include	"FromX.h"


#define	MAX_NUMERATOR	128
#define	LOW_DENUM		1
#define	HIGH_DENUM		32

// clock はKHz単位
void
SiSCalcClock(uint32 argClock)
{
	int theNumerator, theDeNumerator, thePostScaler, theDivider ;
	int bestNumerator, bestDeNumerator, bestDivider;
	double abest = 42.0;	// abestの値見直し要
	double target;
	double Fvco, Fout, bestFout;
	double error, aerror;
	double	theDesiredNumerator;

//	int low_N = 2;
//	int high_N = 5;

	target = argClock * 1000;	// Hz単位に換算

	thePostScaler = 1;
	if (target < MAX_VCO / 2) {
	    thePostScaler = 2;
	}
	if (target < MAX_VCO / 3) {
	    thePostScaler = 3;
	}
	if (target < MAX_VCO / 4) {
	    thePostScaler = 4;
	}
	if (target < MAX_VCO / 6) {
	    thePostScaler = 6;
	}
	if (target < MAX_VCO / 8) {
	    thePostScaler = 8;
	}

	bestFout = -1.0;
	Fvco = thePostScaler * target;

	for (theDeNumerator = LOW_DENUM; theDeNumerator <= HIGH_DENUM; theDeNumerator++){
		theDesiredNumerator = Fvco / FREF * theDeNumerator;

	    if ( theDesiredNumerator > MAX_NUMERATOR ) {
			theNumerator = (int)(theDesiredNumerator / 2 + 0.5);
			if (theNumerator > MAX_NUMERATOR) {
				break;	// もうこれ以上は有効な計算結果がない。
			}
			theDivider = 2;
		} else {
			theNumerator = (int)(Fvco / FREF * theDeNumerator + 0.5);
			theDivider = 1;
		}

		Fout = (double)FREF * (theNumerator * theDivider)/(theDeNumerator * thePostScaler);

		error = (target - Fout) / target;
		aerror = (error < 0) ? -error : error;
		if (aerror < abest) {
			abest = aerror;
			bestNumerator = theNumerator;
			bestDeNumerator = theDeNumerator;
			bestDivider = theDivider;
			bestFout = Fout;
		}
	}

	if (bestFout < HIGH_FRQ) {
		gSEQR.s.fSR7.HSDoperation = 0;
	}else{
		gSEQR.s.fSR7.HSDoperation = 1;
	}

	gSEQR.s.fSR2A.IVnumerator = bestNumerator - 1;
	gSEQR.s.fSR2B.IVdenumerator = bestDeNumerator - 1;
	gSEQR.s.fSR2A.IVdivider = bestDivider - 1;

	switch(thePostScaler) {
	case 1:
		gSEQR.s.fSR13.IVPscale = 0;
		gSEQR.s.fSR2B.IVPscale = 0;
		break;
	case 2:
		gSEQR.s.fSR13.IVPscale = 0;
		gSEQR.s.fSR2B.IVPscale = 1;
		break;
	case 3:
		gSEQR.s.fSR13.IVPscale = 0;
		gSEQR.s.fSR2B.IVPscale = 2;
		break;
	case 4:
		gSEQR.s.fSR13.IVPscale = 0;
		gSEQR.s.fSR2B.IVPscale = 3;
		break;
	case 6:
		gSEQR.s.fSR13.IVPscale = 1;
		gSEQR.s.fSR2B.IVPscale = 2;
		break;
	case 8:
		gSEQR.s.fSR13.IVPscale = 1;
		gSEQR.s.fSR2B.IVPscale = 3;
		break;
	default:
		SERIAL_PRINT(("ySiS accel : invalid Post-Scaler\n"));
		break;
	}
}

/* Auxiliary function to find real memory clock (in Khz) */
int
SiSMclk()
{
	int mclk;

	mclk = 14318*(gSEQR.s.fSR28.Mnumerator+1);
	mclk /= (gSEQR.s.fSR29.Mdenumrator+1);
	mclk *= (gSEQR.s.fSR28.Mdivider + 1);

	/* Post-scaler. Values depends on SR13 bit 7  */
	if ( gSEQR.s.fSR13.MPscale == 0 ) {
		mclk = mclk / (gSEQR.s.fSR29.MPscale+1);
	}else{
		switch(gSEQR.s.fSR29.MPscale) {
		case 2:
			mclk /= 6;
			break;
		case 3:
			mclk /= 8;
			break;
		}
	}

	return mclk;
}

int sisMemBandWidth()
{
	int band;

     band= SiSMclk();

	if (gSEQR.s.fSRC.Mconfiguration == 0) {
		band *= 8;
	}else{
		band *=16;
	}
	if (gSEQR.s.fSR34.DCOCRenable == 0 && gSEQR.s.fSR34.DCOCWenable == 1) {
		band *= 2;
	}
     
	return(band);
}

void
SiSSetThreadhold(uint32 argDepth, uint32 argPixClock)
{
	int	CRT_ENGthreshold = 0x0f;
	int	CRT_CPUthresholdLow;
	int	CRT_CPUthresholdHigh;
	int	MemBand;
	int theSafetymargin = 1; 
	int theGap          = 4;

	MemBand = sisMemBandWidth() / 10 ;
	CRT_CPUthresholdLow = (int)(((argDepth * argPixClock) / MemBand) + theSafetymargin);
	CRT_CPUthresholdHigh = (int)(((argDepth * argPixClock) / MemBand) + theGap + theSafetymargin);

	if ( CRT_CPUthresholdLow > 0xe ) { 
	    CRT_CPUthresholdLow = 0xe; 
	}
	if ( CRT_CPUthresholdHigh > 0x0f ) {
	    CRT_CPUthresholdHigh = 0x0f;
	}
	gSEQR.s.fSR8.CEThigh = CRT_ENGthreshold;
	gSEQR.s.fSR8.CCATlow = CRT_CPUthresholdLow;
	gSEQR.s.fSR9.CCThigh = CRT_CPUthresholdHigh;
}
