/*
	Copyright 1999, Be Incorporated.   All Rights Reserved.
	This file may be used under the terms of the Be Sample Code License.

	SiS6326 graphics card accelerant
	written by Yasutaka Uematu (yasutaka2000@bemail.org)
*/

#include	<support/Debug.h>	// y_SiS
#include	"SiSdebugutil.h"	// y_SiS
#include "GlobalData.h"
#include "generic.h"

/*
	Return the current display mode.  The only time you might return an
	error is if a mode hasn't been set.
*/
status_t GET_DISPLAY_MODE(display_mode *current_mode) {
	/* easy for us, we return the last mode we set */
	SERIAL_PRINT(("ySiS accel : enter GET_DISPLAY_MODE()\n"));	// y_SiS
	*current_mode = si->dm;
//	SERIAL_PRINT(("ySiS accel : in GET_DISPLAY_MODE() return current mode info.\n"));	// y_SiS
//	utlDUMP_DISPLAY_MODE(si->dm);							// y_SiS
//	SERIAL_PRINT(("ySiS accel : leave GET_DISPLAY_MODE()\n"));	// y_SiS
	return B_OK;
}

/*
	Return the frame buffer configuration information.
*/
status_t GET_FRAME_BUFFER_CONFIG(frame_buffer_config *afb) {
	/* easy again, as the last mode set stored the info in a convienient form */
	SERIAL_PRINT(("ySiS accel : enter GET_FRAME_BUFFER_CONFIG()\n"));	// y_SiS
//	SERIAL_PRINT(("ySiS accel : si->fbc.frame_buffer = %08x, si->fbc.frame_buffer_dma = %08x, si->fbc.bytes_per_row = %08x\n", si->fbc.frame_buffer, si->fbc.frame_buffer_dma,si->fbc.bytes_per_row));	// y_SiS
	*afb = si->fbc;
	return B_OK;
}

/*
	Return the maximum and minium pixel clock limits for the specified mode.
*/
status_t GET_PIXEL_CLOCK_LIMITS(display_mode *dm, uint32 *low, uint32 *high) {
/*
	Note that we're not making any guarantees about the ability of the attached
	display to handle pixel clocks within the limits we return.  A future monitor
	capablilities database will post-process this information.
*/
	uint32 total_pix = (uint32)dm->timing.h_total * (uint32)dm->timing.v_total;
	uint32 clock_limit;

	SERIAL_PRINT(("ySiS accel : enter GET_PIXEL_CLOCK_LIMITS()\n"));	// ySiS
	/* max pixel clock is pixel depth dependant */
	switch (dm->space & ~0x3000) {
		case B_RGB32: clock_limit = si->pix_clk_max32; break;
		case B_RGB15:
		case B_RGB16: clock_limit = si->pix_clk_max16; break;
		case B_CMAP8: clock_limit = si->pix_clk_max8; break;
		default:
			clock_limit = 0;
	}
	/* lower limit of about 48Hz vertical refresh */
	*low = (total_pix * 48L) / 1000L;
	if (*low > clock_limit) return B_ERROR;
	*high = clock_limit;

//	SERIAL_PRINT(("ySiS accel : leave GET_PIXEL_CLOCK_LIMITS() *low = %ul, *high = %ul\n", *low, *high));	// ySiS

	return B_OK;
}

/*
	Return the semaphore id that will be used to signal a vertical retrace
	occured.
*/
sem_id ACCELERANT_RETRACE_SEMAPHORE(void) {
	/*
	NOTE:
		The kernel driver created this for us.  We don't know if the system is
		using real interrupts, or if we're faking it, and we don't care.
		If we choose not to support this at all, we'd just return B_ERROR here,
		and the user wouldn't get any kind of vertical retrace support.
	*/
	SERIAL_PRINT(("ySiS accel : enter - leave ACCELERANT_RETRACE_SEMAPHORE() si->vblank = %d\n", si->vblank));	// y_SiS
	return si->vblank;
}
