//
// SiSModeSet.c
//	A part of SiS6326 driver for BeOS
//	Copyright (C) 2000 Yasutaka Uematu All rights reserved.
//	yasutaka2000@bemail.org
//

#include	<support/Debug.h>
#include	"SiSdebugutil.h"
#include	"GlobalData.h"
#include	"generic.h"
#include	"SiSaccelData.h"
#include	"SiSaccelutil.h"
#include	"SiSDriverIF.h"
#include	"IOaccess.h"
#include	"SiSgamma.h"
#include	"FromX.h"

extern uint32	calcBitsPerPixel(uint32);
extern uint8	SiSGetSR11(void);			// SetDisplayMode.c

// functions
void	SetHorizontal(int , int , int , int );
void	SetVertical(int , int , int , int );
void	SiSInitRes(display_mode *);

//
// set Horizontal 
void
SetHorizontal(int argHtotal, int argHactive, int argHRstart, int argHRend)
{
	int	theHtotal;
	int	theHDEend;	// Horizontal Display Enable End
	int	theHBstart;	// Horizontal Blank Start
	int	theHBend;		// Horizontal Blank End
	int	theHRstart;	// Horizontal Retrace Start
	int	theHRend;		// Horizontal Retrace End

	theHtotal = (argHtotal / 8) - 5;
	gCRTC.s.fCR0.Htotal = (uint8)(theHtotal & 0xff);
	gSEQR.s.fSR12.EHtotal8 = (uint8)((theHtotal & 0x100) >> 8);

	theHDEend = (argHactive / 8) - 1;
	gCRTC.s.fCR1.HDEend = (uint8)(theHDEend & 0xff);
	gSEQR.s.fSR12.EHDEend8 = (uint8)((theHDEend & 0x100) >> 8);

	theHBstart = theHDEend;
	gCRTC.s.fCR2.HBstart = (uint8)(theHBstart & 0xff);
	gSEQR.s.fSR12.EHBstart8 = (uint8)((theHBstart & 0x100) >> 8);

	theHBend = theHBstart + ((argHtotal - argHactive)/ 8);
	gCRTC.s.fCR3.HBend40 = theHBend & 0x1f;
	gCRTC.s.fCR5.HBend5 = (theHBend >> 5);
	gSEQR.s.fSR12.EHBend6 = (theHBend >> 6);

	theHRstart = (argHRstart / 8);
	gCRTC.s.fCR4.HRstart = (uint8)theHRstart;
	gSEQR.s.fSR12.EHRstart8 = (theHRstart & 0x100) >> 8;

	theHRend = argHRend / 8;
	gCRTC.s.fCR5.HRend = theHRend & 0x1f;
}

//
// set Vertical
void
SetVertical(int argVtotal, int argVactive, int argVRstart, int argVRend)
{
	int	theVtotal;	// Vertical total
	int	theVDEend;	// Vertical Display Enable End
	int	theVBstart;	// Vertical Blank Start
	int	theVBend;	// Vertical Blank End
	int	theVRstart;	// Vertical Retrace Start
	int	theVRend;	// Vertical Retrace End

	theVtotal = argVtotal - 2;
	gCRTC.s.fCR6.Vtotal70 = (uint8)(theVtotal & 0xff);
	gCRTC.s.fCR7.Vtotal8 = (theVtotal & 0x100) >> 8;
	gCRTC.s.fCR7.Vtotal9 = (theVtotal & 0x200) >> 9;
	gSEQR.s.fSRA.EVtotal10 = (theVtotal & 0x400) >> 10;

	theVDEend = argVactive - 1;
	gCRTC.s.fCR12.VDEend70 = (uint8)(theVDEend & 0xff);
	gCRTC.s.fCR7.VDEend8 = (theVDEend & 0x100) >> 8;
	gCRTC.s.fCR7.VDEend9 = (theVDEend & 0x200) >> 9;
	gSEQR.s.fSRA.EVDEend10 = (theVDEend & 0x400) >> 10;

	theVBstart = theVDEend;
	gCRTC.s.fCR15.VBstart70 = (uint8)(theVBstart & 0xff);
	gCRTC.s.fCR7.VBstart8 = (theVBstart & 0x100) >> 8;
	gCRTC.s.fCR9.VBstart9 = (theVBstart & 0x200) >> 9;
	gSEQR.s.fSRA.EVBstart10 = (theVBstart & 0x400) >> 10;

	theVBend = theVBstart + ((argVtotal - argVactive) / 8);
	gCRTC.s.fCR16.VBend = (uint8)(theVBend & 0xff);

	theVRstart = argVRstart;
	gCRTC.s.fCR10.VRstart70 = (uint8)(theVRstart & 0xff);
	gCRTC.s.fCR7.VRstart8 = (theVRstart & 0x100) >> 8;
	gCRTC.s.fCR7.VRstart9 = (theVRstart & 0x200) >> 9;
	gSEQR.s.fSRA.EVRstart10 = (theVRstart & 0x400) >> 10;

	theVRend = argVRend;
	gCRTC.s.fCR11.VRend = theVRend & 0x0f;
}

//
// Initialize Resolution
void
SiSInitRes(display_mode *dm)
{
	display_timing	tm;
	uint32		theDepth;
	uint32		theRows;
	tIOGammaTbl	theGamma;

	SERIAL_PRINT(("y_SiS accel : enter SiSInitRes()\n"));

	// 表示を停止する。
	SiSEnableDisplay(false);
	// Suspend + Standby = Off
	gSEQR.fValue[0x11] = SiSGetSR11();
	gSEQR.s.fSR11.FVsuspend = 1;
	gSEQR.s.fSR11.FVstandby = 1;
	SeqOut(0x11, gSEQR.fValue[0x11]);
			
	snooze(20833 * 4);	// Delay at least 2/48th second.(48Hz is the lowest refresh rate this driver will accept. 2 is for 2 frames.)

	tm = dm->timing;
	// Horizontal
	SetHorizontal(tm.h_total, tm.h_display, tm.h_sync_start, tm.h_sync_end);
	// Vertical
	SetVertical(tm.v_total, tm.v_display, tm.v_sync_start, tm.v_sync_end);
	// Screen Offset
	theDepth = calcBitsPerPixel(dm->space);
	theRows = (theDepth / 8) * (dm->virtual_width / 8);
	gCRTC.s.fCR13.Soffset = (uint8)(theRows & 0xff);
	gSEQR.s.fSRA.ESoffset118 = theRows >> 8;
	// 256,32k,64k color-mode
	switch(dm->space) {
	case B_CMAP8:
		gGCTR.s.fGR5.C256mode = 1;
		gSEQR.s.fSR6.C32KGMenable = 0;
		gSEQR.s.fSR6.C64KGMenable = 0;
		gSEQR.s.fSR6.TCGMenable = 0;
		// Gamma Correctionを無効にする。
		{
			theGamma.fToken = kGAMMA_SET_TOKEN;
			theGamma.fEnable = false;
			(void)ioctl(fd, YSIS_SET_GAMMA, &theGamma);
			gSEQR.s.fSR7.CP24fDCmode = 0;
		}
		break;
	case B_RGB15_BIG:	// y_SiS ??? どちらか？
	case B_RGBA15_BIG:	// y_SiS ???
	case B_RGB15_LITTLE:	// y_SiS ???
	case B_RGBA15_LITTLE:	// y_SiS ???
		gGCTR.s.fGR5.C256mode = 0;
		gSEQR.s.fSR6.C32KGMenable = 1;
		gSEQR.s.fSR6.C64KGMenable = 0;
		gSEQR.s.fSR6.TCGMenable = 0;
		{
			double	theGammaValue;
			// gamma correctionの設定を取り出す
			if (GetGammaPref(&theGammaValue) == true) {
				CalcGamma(&theGamma, theGammaValue);
				gSEQR.s.fSR7.CP24fDCmode = 1;	// 大域変数に反映する
			}else{
				theGamma.fToken = kGAMMA_SET_TOKEN;
				theGamma.fEnable = false;
				gSEQR.s.fSR7.CP24fDCmode = 0;	// 大域変数に反映する
			}	
			ioctl(fd, YSIS_SET_GAMMA, &theGamma);
		}	
		break;
	case B_RGB16_BIG:
	case B_RGB16_LITTLE:
		gGCTR.s.fGR5.C256mode = 0;
		gSEQR.s.fSR6.C32KGMenable = 0;
		gSEQR.s.fSR6.C64KGMenable = 1;
		gSEQR.s.fSR6.TCGMenable = 0;
		{
			double	theGammaValue;
			// gamma correctionの設定を取り出す
			if (GetGammaPref(&theGammaValue) == true) {
				CalcGamma(&theGamma, theGammaValue);
				gSEQR.s.fSR7.CP24fDCmode = 1;	// 大域変数に反映する
			}else{
				theGamma.fToken = kGAMMA_SET_TOKEN;
				theGamma.fEnable = false;
				gSEQR.s.fSR7.CP24fDCmode = 0;	// 大域変数に反映する
			}	
			ioctl(fd, YSIS_SET_GAMMA, &theGamma);
		}	
		break;
	default:	// 256-colorを仮定する
		gGCTR.s.fGR5.C256mode = 1;
		gSEQR.s.fSR6.C32KGMenable = 0;
		gSEQR.s.fSR6.C64KGMenable = 0;
		gSEQR.s.fSR6.TCGMenable = 0;
		// Gamma Correctionを無効にする。
		{
			theGamma.fToken = kGAMMA_SET_TOKEN;
			theGamma.fEnable = false;
			(void)ioctl(fd, YSIS_SET_GAMMA, &theGamma);
			gSEQR.s.fSR7.CP24fDCmode = 0;
		}
	}

	// True-Color Graphics mode RGB Sequence Selection
	gSEQR.s.fSRB.TCGMRGBSselection = 0;
	// 16-color packed pixel enable
	gSEQR.s.fSRB.C16PPenable = 0;
	// Linear Addressing Space Aperture Bit(8MB)
	gSEQR.s.fSR21.LASaperture = 3;

	SiSCalcClock(tm.pixel_clock);

	SiSSetThreadhold(theDepth, tm.pixel_clock);
	
	// レジスタの値を更新する
	{
		gCRTC.s.fCR11.Wprotect = 0;
		CrtOut(0x11, gCRTC.fValue[0x11]);	

		CrtOut(0x13, gCRTC.fValue[0x13]);		/* When set VCLK, you should set CR13 first と言うことらしい */

		CrtOut(0x0,  gCRTC.fValue[0x0]);
		CrtOut(0x1,  gCRTC.fValue[0x1]);
		CrtOut(0x2,  gCRTC.fValue[0x2]);
		CrtOut(0x3,  gCRTC.fValue[0x3]);
		CrtOut(0x4,  gCRTC.fValue[0x4]);
		CrtOut(0x5,  gCRTC.fValue[0x5]);
		SeqOut(0x12, gSEQR.fValue[0x12]);

		CrtOut(0x6, gCRTC.fValue[0x06]);
		CrtOut(0x7, gCRTC.fValue[0x07]);
		CrtOut(0x9, gCRTC.fValue[0x09]);
		CrtOut(0x10, gCRTC.fValue[0x10]);
		CrtOut(0x11, gCRTC.fValue[0x11]);
		CrtOut(0x12, gCRTC.fValue[0x12]);
		CrtOut(0x15, gCRTC.fValue[0x15]);
		CrtOut(0x16, gCRTC.fValue[0x16]);

		SeqOut(0x0a, gSEQR.fValue[0x0a]);
						
		GctOut(0x05, gGCTR.fValue[0x05]);
		SeqOut(0x06, gSEQR.fValue[0x06]);
		SeqOut(0x07, gSEQR.fValue[0x07]);

		SeqOut(0x08, gSEQR.fValue[0x08]);
		SeqOut(0x09, gSEQR.fValue[0x09]);
		
		SeqOut(0x0b, gSEQR.fValue[0x0b]);
		SeqOut(0x21, gSEQR.fValue[0x21]);

		SeqOut(0x07, gSEQR.fValue[0x07]);
		SeqOut(0x13, gSEQR.fValue[0x13]);
		SeqOut(0x2a, gSEQR.fValue[0x2a]);
		SeqOut(0x2b, gSEQR.fValue[0x2b]);
	}
	// チップのリセット
	SiSReset();

	// 疑似割り込みのための、リフレッシュレートを設定する。
	si->refresh_period = (bigtime_t)(
			(1.0 / ( (double)tm.pixel_clock / ((double)tm.h_total * (double)tm.v_total)) ) * 1000.0);
	si->blank_period = (bigtime_t)(
			(1.0 / ( (double)tm.pixel_clock / ((double)tm.h_total * (double)(tm.v_total - tm.v_display)) ) ) * 1000.0);
	SERIAL_PRINT(("si->refresh_period = %Ld\n", si->refresh_period));
	SERIAL_PRINT(("si->blank_period = %Ld\n", si->blank_period));

	snooze(20833 * 4);
	// CRT ON
	gSEQR.fValue[0x11] = SiSGetSR11();
	gSEQR.s.fSR11.FVsuspend = 0;
	gSEQR.s.fSR11.FVstandby = 0;
	SeqOut(0x11, gSEQR.fValue[0x11]);
	// 表示を再開する。
	SiSEnableDisplay(true);
	SERIAL_PRINT(("y_SiS accel : leave SiSInitRes()\n"));
}

