//
//	SiSdebugutil.c
//	A part of SiS6326 driver for BeOS
//	Copyright (C) 2000 Yasutaka Uematu All rights reserved.
//	yasutaka2000@bemail.org
//
#include	<SupportDefs.h>
#include	<support/Debug.h>
#include	"SiSaccelData.h"
#include	"SiSdebugutil.h"

extern void readGeneric(void);
extern void readCRTC(void);
extern void readGCTR(void);
extern void readSEQR(void);
extern void readATRR(void);

void
dispGeneric()
{
    SERIAL_PRINT(("Misc. Output = %02x\n", gMiscOut));
    SERIAL_PRINT(("Feature Control = %02x\n", gFeature));
    SERIAL_PRINT(("Input Status 0 = %02x\n", gIStatus0));
    SERIAL_PRINT(("Input Status 1 = %02x\n", gIStatus1));
    SERIAL_PRINT(("VGA Enable = %02x\n", gVGAEnable));
    SERIAL_PRINT(("Segment Selection 0 = %02x\n", gSegSel0));
    SERIAL_PRINT(("Segment Selection 1 = %02x\n", gSegSel1));
}

void
utlDISP_REGS(void)
{
    int     theLoop;

    readGeneric();
    readCRTC();
    readSEQR();
    readGCTR();
    readATRR();

    dispGeneric();

    SERIAL_PRINT(("CRTC---\n"));
    for(theLoop = 0; theLoop <= 0x26; theLoop++) {
        SERIAL_PRINT(("%02x %02x\n", theLoop, gCRTC.fValue[theLoop]));
    }

    SERIAL_PRINT(("SEQR---\n"));
    for(theLoop = 0; theLoop <= 0x3c; theLoop++) {
        SERIAL_PRINT(("%02x %02x\n", theLoop, gSEQR.fValue[theLoop]));
    }

    SERIAL_PRINT(("GCTR---\n"));
    for(theLoop = 0; theLoop <= 0x8; theLoop++) {
        SERIAL_PRINT(("%02x %02x\n", theLoop, gGCTR.fValue[theLoop]));
    }

    SERIAL_PRINT(("ATRR---\n"));
    for(theLoop = 0; theLoop < 21; theLoop++) {
        SERIAL_PRINT(("%02x %02x\n", theLoop, gATRR.fValue[theLoop]));
    }
}
