//
//	Swap2Little.h
//	A part of SiS6326 driver for BeOS
//	Copyright (C) 2000 Yasutaka Uematu All rights reserved.
//	yasutaka2000@bemail.org
//
#ifndef	_SWAP2LITTLE_H_
#define	_SWAP2LITTLE_H_

#include	<SupportDefs.h>

inline vuint32
swap32(vuint32 argVal)
{
	union {
		uint8	f8[4];
		uint32	f32;
	} u;
	uint8	theSwap;

	u.f32 = argVal;
	theSwap = u.f8[0];
	u.f8[0] = u.f8[3];
	u.f8[3] = theSwap;

	theSwap = u.f8[1];
	u.f8[1] = u.f8[2];
	u.f8[2] = theSwap;
	
	return u.f32;
}

inline vuint16
swap16(vuint16 argVal)
{
	volatile union {
		uint8	f8[2];
		uint16	f16;
	} u;
	uint8	theSwap;

	u.f16 = argVal;
	theSwap = u.f8[0];
	u.f8[0] = u.f8[1];
	u.f8[1] = theSwap;
	
	return u.f16;
}

#endif
