//
// SiSkernutil.h
//
//	A part of SiS6326 driver for BeOS
//	Copyright (C) 2000 Yasutaka Uematu All rights reserved.
//	yasutaka2000@bemail.org
// 

#ifndef	_SISKERNUTIL_H_
#define	_SISKERNUTIL_H_

#include	"SiSDriverIF.h"

#define	inb(_o)		((*pci_bus->read_io_8)(_o))
#define	outb(_o,_v)	((*pci_bus->write_io_8)(_o, _v))

#define	SEQ_IDX	(gIOBase + 0x4)
#define	SEQ_DATA	(gIOBase + 0x5)
#define	CRT_IDX	(gIOBase + 0x14)
#define	CRT_DATA	(gIOBase + 0x15)
#define	GCT_IDX	(gIOBase + 0xe)
#define	GCT_DATA (gIOBase + 0xf)
#define	ATR_IDX	(gIOBase + 0x0)
#define	ATR_READ	(gIOBase + 0x1)
#define	ATR_WRITE	(gIOBase + 0x0)

#define	DAC_STATUS	(gIOBase + 0x07)
#define	DAC_READ_IDX	(gIOBase + 0x07)
#define	DAC_WRITE_IDX	(gIOBase + 0x08)
#define	DAC_DATA		(gIOBase + 0x09)
#define	DAC_PEL_MASK	(gIOBase + 0x06)

#define	ISTATUS0	(gIOBase + 0x2)
#define	ISTATUS1	(gIOBase + 0x1a)

// public functions
void	SiSReset(void);
bool	SiSUnlockRegs(void);
void	SiSKillPort(void);
bool	SiSIsVintPending(void);
void	SiSClearVint(int);
bool	SiSIsVblank(shared_info *);
bool	SiSEnableVint(bool);
status_t SiSReadPort(tIOAccess *);
status_t SiSWritePort(tIOAccess *);
status_t SiSReadIndexed(tIOIdxAccess *);
status_t SiSWriteIndexed(tIOIdxAccess *);
status_t SiSSetGamma(tIOGammaTbl *);
status_t SiSSetDAC(tIOGammaTbl *);
void	SiSEnableDisplay(bool);
void	SiSSEQClear(void);
void	SiSCRTCClear(void);
void	SiSGCTRClear(void);
void	SiSATRRClear(void);

#endif