//
// uATRR.h (ppc)
//	A part of SiS6326 driver for BeOS
//	Copyright (C) 2000 Yasutaka Uematu All rights reserved.
//	yasutaka2000@bemail.org
//

//00h - 0fh	Color Palette Register 0 - 15
//
typedef	struct {
	//D[7:6]	Reserved
	uchar	Reserved	:2;
	//D[5:0]	Palette Entries
	uchar	Pentries	:6;
} AR0F;

//10h	Mode Control Register
typedef	struct {
	//D7	P4, P5 Source Select
	//	0:  AR0-F Bit[5:4] are used as the source for the Lookup Table Address Bit[5:4]
	//	1:  AR14 Bit[1:0] are used as the source for the Lookup Table Address Bit[5:4]
	uchar	P4P5Sselect	:1;

	//D6	Pixel Double Clock Select
	//	0:  The pixels are clocked at every clock cycle
	//	1:  The pixels are clocked at every other clock cycle
	uchar	PDCselect	:1;

	//D5	PEL Panning Compatibility with Line Compare
	//	0:  Disable
	//	1:  Enable
	uchar	PPCwLcompare:1;

	//D4	Reserved
	uchar	Reserved	:1;

	//D3	Background Intensity or Blink enable (while the Character Attribute D7=1)
	//	0:  Background Intensity attribute enable
	//	1:  Background Blink attribute enable
	uchar	BIBenable	:1;

	//D2	Line Graphics enable
	//	0:  The ninth bit of nine-bit-wide character cell will be the same as the background.
	//	1:  The ninth bit of nine-bit-wide character cell will be made be the same as the eighth bit for character codes in the range C0h through DFh.
	uchar	LGenable	:1;

	//D1	Display Type
	//	0:  The contents of the Attribute byte are treated as color attribute.
	//	1:  The contents of the Attribute byte are treated as MDA-compatible attribute.
	uchar	Dtype		:1;

	//D0	Graphics/Text Mode
	//	0:  The Attribute Controller will function in text mode.
	//	1:  The Attribute Controller will function in graphics mode.
	uchar	GTmode		:1;
} AR10;

//11h	Screen Border Color
typedef struct {
	//D[7:6]	Reserved
	uchar	Reserved	:2;

	//D[5:0]	Palette Entry
	uchar	Pentry		:6;
} AR11;

//12h	Color Plane Enable Register
typedef	struct {
	//	These bits select two of the eight bits color outputs to be available in the status register. The output color combinations available on the status bits are as follows:
	//D[7:6]	Reserved
	uchar	Reserved	:2;

	//D[5:4]	Display Status MUX Bit[1:0]
	uchar	DSmux		:2;

	//D[3:0]	Enable Color Plane Bit[3:0]
	uchar	ECplane		:4;
} AR12;

//13h	Pixel Panning Register
typedef struct {
	//D[7:4]	Reserved
	uchar	Reserved:4;

	//D[3:0]	Pixel Pan Bit[3:0]
	//This field specifies the number of pixels the display data will be shifted to the left.  This field is interpreted as indicated in the following table:
	uchar	Ppan	:4;
} AR13;

//14h	Color Select Register (VGA)
typedef	struct {
	//D[7:4]	Reserved
	uchar	Reserved	:4;

	//D[3:2]	Color Bit[7:6]
	//These two bits are concatenated with the six bits from the Palette Register to form the address into the LUT and to drive P[7:6].
	uchar	Color76		:2;

	//D[1:0]	Color Bit[5:4]
	//If AR10 D7 is programmed to a '1', these two bits replace the corresponding two bits from the Palette Register to form the address into the LUT and to drive P[5:4]. If AR10 D7 is programmed to a '0', these two bits are ignored.
	uchar	Color54		:2;
} AR14;

typedef union _uATRR {
	struct {
		AR0F	fAR0F[16];
		AR10	fAR10;
		AR11	fAR11;
		AR12	fAR12;
		AR13	fAR13;
		AR14	fAR14;
	} s;
	uint8	fValue[21];
} uATRR;
