//
// uGCTR.h
//

//00	Set/Reset Register
typedef struct {
	//D0	Set/Reset Map for plane 0
	uchar	SRMP0	:1;
	//D1	Set/Reset Map for plane 1
	uchar	SRMP1	:1;
	//D2	Set/Reset Map for plane 2
	uchar	SRMP2	:1;
	//D3	Set/Reset Map for plane 3
	uchar	SRMP3	:1;
	//D[7:4]	Reserved
	uchar	Reserved:4;
} GR0;

//01	Set/Reset Enable Register
typedef struct {
	//D0	Enable Set/Reset for plane 0
	uchar	ESRP0	:1;
	//D1	Enable Set/Reset for plane 1
	uchar	ESRP1	:1;
	//D2	Enable Set/Reset for plane 2
	uchar	ESRP2	:1;
	//D3	Enable Set/Reset for plane 3
	uchar	ESRP3	:1;
	//D[7:4]	Reserved
	uchar	Reserved:4;
} GR1;

//02	Color Compare Register
typedef struct {
	//D0	Color Compare Map for plane 0
	uchar	CCMP0	:1;
	//D1	Color Compare Map for plane 1
	uchar	CCMP1	:1;
	//D2	Color Compare Map for plane 2
	uchar	CCMP2	:1;
	//D3	Color Compare Map for plane 3
	uchar	CCMP3	:1;
	//D[7:4]	Reserved
	uchar	Reserved:4;
} GR2;

//03	Data Rotate & Function Select
typedef struct {
	//D[2:0]	Rotate Count
	uchar	Rcount		:3;
	//D[4:3]	Function Select
	uchar	Fselect		:2;
	//D[7:5]	Reserved
	uchar	Reserved	:3;
} GR3;

//04	Read Plane Select Register
typedef struct {
	//D[1:0]	Read Plane Select bit 1, 0
	uchar	RPselect	:2;
	//D[7:2]	Reserved
	uchar	Reserved	:6;
} GR4;

//05	Mode Register
typedef struct {
	//D[1:0]	Write mode
	uchar	Wmode		:2;
	//D2	Reserved
	uchar	Reserved2	:1;
	//D3	Read Mode
	uchar	Rmode		:1;
	//D4	Odd/Even Addressing Mode enable
	uchar	OEAMenable	:1;
	//D5	Shift Register Mode
	uchar	SRmode		:1;
	//D6	256-color Mode
	uchar	C256mode	:1;
	//D7	Reserved
	uchar	Reserved1	:1;
} GR5;

//06	Miscellaneous Register
typedef struct {
	//D0	Graphics Mode Enable
	uchar	GMenable	:1;
	//D1	Chain Odd And Even Maps 
	uchar	COEmaps		:1;
	//D[3:2]	Memory Address Select
	uchar	MAselect	:2;
	//D[7:4]	Reserved
	uchar	Reserved	:4;
} GR6;

//07	Color Don't Care Register
typedef	struct {
	//D0	Plane 0 Don't Care
	uchar	P0Dcare		:1;
	//D1	Plane 1 Don't Care
	uchar	P1Dcare		:1;
	//D2	Plane 2 Don't Care
	uchar	P2Dcare		:1;
	//D3	Plane 3 Don't Care
	uchar	P3Dcare		:1;
	//D[7:4]	Reserved
	uchar	Reserved	:4;
} GR7;

//08	Bit Mask Register
typedef struct {
	//D[7:0]	Bit Mask Enable Bit
	uint8	BMenable;
} GR8;

typedef union _uGCTR {
	struct {
		GR0		fGR0;
		GR1		fGR1;
		GR2		fGR2;
		GR3		fGR3;
		GR4		fGR4;
		GR5		fGR5;
		GR6		fGR6;
		GR7		fGR7;
		GR8		fGR8;
	} s;
	uint8	fValue[9];
} uGCTR;
