//
//	IOaccess.c
//	A part of SiS6326 driver for BeOS
//	Copyright (C) 2000 Yasutaka Uematu All rights reserved.
//	yasutaka2000@bemail.org
//
#include	<unistd.h>
#include	<SupportDefs.h>
#include	"GlobalData.h"		// for fd.
#include	"SiSDriverIF.h"
#include	"IOaccess.h"

uint8
inb(uint16 argOffset)
{
	tIOAccess	theIO;
	theIO.fOffset = argOffset;
	ioctl(fd, YSIS_READ_PORT, &theIO);
	return theIO.fValue;
}

void
outb(uint16 argOffset, uint8 argValue)
{
	tIOAccess	theIO;
	theIO.fOffset = argOffset;
	theIO.fValue = argValue;
	ioctl(fd, YSIS_WRITE_PORT, &theIO);
}
