//
//	IOaccess.h
//	A part of SiS6326 driver for BeOS
//	Copyright (C) 2000 Yasutaka Uematu All rights reserved.
//	yasutaka2000@bemail.org
//

#ifndef	_YSIS_IOACCESS_H_
#define	_YSIS_IOACCESS_H_

#ifdef  __cplusplus
extern "C" {
#endif

#include	<unistd.h>
#include	<SupportDefs.h>
#include	"GlobalData.h"		// for fd.
#include	"SiSDriverIF.h"

uint8 inb(uint16 argPort);
void outb(uint16 argPort,  uint8 argValue);

#define	IOP_MISC_READ	(0xc)
#define	IOP_MISC_WRITE	(0x2)

#define	IOP_FEATURE_READ	(0xa)
#define	IOP_FEATURE_WRITE	(0x1a)

#define	IOP_ISTATUS0	(0x2)
#define	IOP_ISTATUS1	(0x1a)

#define	IOP_VGAENABLE	(0x03)

#define	IOP_SEGSEL0		(0x0d)
#define	IOP_SEGSEL1		(0x0b)

#define SEQ_IDX     (0x4)
#define SEQ_DATA    (0x5)

#define CRT_IDX     (0x14)
#define CRT_DATA    (0x15)

#define GCT_IDX		(0xe)
#define GCT_DATA    (0xf)

#define ATR_IDX		(0x0)
#define ATR_READ    (0x1)
#define ATR_WRITE   (0x0)

#define DAC_STATUS      (0x07)
#define DAC_READ_IDX    (0x07)
#define DAC_WRITE_IDX   (0x08)
#define DAC_DATA        (0x09)
#define DAC_PEL_MASK    (0x06)

#ifdef  __cplusplus
}
#endif

#endif
