//
// SiSgamma.c
//	A part of SiS6326 driver for BeOS
//	Copyright (C) 2000 Yasutaka Uematu All rights reserved.
//
#include	<stdio.h>
#include	<string.h>
#include	<math.h>
#include	"SiSgamma.h"
#include	<unistd.h>
#include	<fcntl.h>
//
// Gamma Inverse.
//
void
CalcGamma(tIOGammaTbl *argTbl, double argVal)
{
	int		theLoop;
	double	theR;
	double	theG;
	double	theB;

	argTbl->fToken = kGAMMA_SET_TOKEN;	
	argTbl->fEnable = true;
	for(theLoop = 0; theLoop < 256; theLoop++) {
		theR = pow(((double)theLoop/255.0),(1.0/argVal)) * 255;
		if (theR > 255.0) {
			theR = 255.0;
		}
		argTbl->fDACValue[theLoop * 3] = (uint8)theR;

		theG = pow(((double)theLoop/255.0),(1.0/argVal)) * 255;
		if (theG > 255.0) {
			theG = 255.0;
		}
		argTbl->fDACValue[theLoop * 3 + 1] = (uint8)theG;

		theB = pow(((double)theLoop/255.0),(1.0/argVal)) * 255;
		if (theB > 255.0) {
			theB = 255.0;
		}
		argTbl->fDACValue[theLoop * 3 + 2] = (uint8)theB;
	}
}

bool
GetGammaPref(double *retValue)
{
	int		thePrefFD;

	char		theFileBuf[256];
	char		*theStr;
	bool		retEnable;

	retEnable = false;
	*retValue = 1.0;
		
	thePrefFD = open(kPREFFILE, O_RDONLY);
	if (thePrefFD >= 0) {
		if (read(thePrefFD, theFileBuf, sizeof(theFileBuf) - 1)) {
			theStr = strtok(theFileBuf, " \t");
			if (theStr && (strcmp("Gamma", theStr) == 0)) {
				theStr = strtok(NULL, " \t\n");
				if (strcmp(theStr ,"disabled") != 0) {
					sscanf(theStr, "%lf", retValue);
					if (*retValue < 0.5) {
						*retValue = 0.5;
					}
					if (*retValue > 2.5) {
						*retValue = 2.5;
					}
					retEnable = true;
				}
			}
		}
		close(thePrefFD);
	}
	return retEnable;
}
