//
//	uCRTC.h (ppc)
//	A part of SiS6326 driver for BeOS
//	Copyright (C) 2000 Yasutaka Uematu All rights reserved.
//	yasutaka2000@bemail.org
//
// H = horizontal
// D = display, delay
// E = enable
// B = blank
// S = skew
#ifndef	_UCRTC_H_
#define	_UCRTC_H_

// posix/termios.h defines CR0, CR1, CR2, CR3. sucks!
#ifdef	CR0
#error	Never include <sys/ioctl.h> !
#endif

//00h	Horizontal Total
typedef	struct {
	uint8	Htotal;
} CR0;

//01h	Horizontal Display Enable End
typedef struct {
	uint8	HDEend;
} CR1;

//02h	Horizontal Blank Start
typedef	struct {
	uint8	HBstart;
} CR2;

//03h	Horizontal Blank End
typedef struct {
	uchar Reserved1	:1;
	uchar DScontrol	:2;
	uchar HBend40	:5;
} CR3;

//04h	Horizontal Retrace Start
typedef struct {
	uint8	HRstart;
} CR4;

//05h	Horizontal Retrace End
typedef struct {
	uchar HBend5	:1;
	uchar HRdelay	:2;
	uchar HRend		:5;
} CR5;

//06h	Vertical Total
typedef	struct {
	uint8	Vtotal70;
} CR6;

//07h	Overflow Register
typedef	struct {
	uchar VRstart9	:1;
	uchar VDEend9	:1;
	uchar Vtotal9	:1;
	uchar Lcompare8	:1;
	uchar VBstart8	:1;
	uchar VRstart8	:1;
	uchar VDEend8	:1;
	uchar Vtotal8	:1;
} CR7;

//08h	Preset Row Scan
typedef	struct {
	uchar Reserved	:1;
	uchar BPctrl	:2;
	uchar PRscan	:5;
} CR8;

//09h	Max Scan Line/Text Character Height
typedef struct {
	uchar Dscan		:1;
	uchar Lcompare9	:1;
	uchar VBstart9	:1;
	uchar CCheight	:5;
} CR9;

//0Ah	Text Cursor Start
typedef struct {
	uchar Reserved	:2;
	uchar TCoff		:1;
	uchar TCstart	:5;
} CRA;

//0Bh	Text Cursor End
typedef struct {
	uchar Reserved	:1;
	uchar TCskew	:2;
	uchar TCend		:5;
} CRB;

//0Ch	Screen Start Address High
typedef struct {
	uint8	SSaddr158;
} CRC;

//0Dh	Screen Start Address Low
typedef	struct {
	uint8	SSaddr70;
} CRD;

//0Eh	Text Cursor Location High
typedef struct {
	uint8	TClocation158;
} CRE;

//0Fh	Text Cursor Location Low
typedef struct {
	uint8	TClocation70;
} CRF;

//10h	Vertical Retrace Start
typedef	struct {
	uint8	VRstart70;
} CR10;

//11h	Vertical Retrace End
typedef struct {
	uchar	Wprotect:1;
	uchar	ARrate	:1;
	uchar	VIenable:1;
	uchar	VIclear	:1;
	uchar	VRend	:4;
} CR11;

//12h	Vertical Display Enable End
typedef struct {
	uint8	VDEend70;
} CR12;

//13h	Screen Offset
typedef struct {
	uint8	Soffset;
} CR13;

//14h	Underline Location
typedef struct {
	uchar	Reserved	:1;
	uchar	DWMenable	:1;
	uchar	CB4			:1;
	uchar	ULlocation	:5;
} CR14;

//15h	Vertical Blank Start
typedef struct {
	uint8	VBstart70;
} CR15;

//16h	Vertical Blank End
typedef struct {
	uint8	VBend;
} CR16;

//17h	Mode Control
typedef struct {
	uchar	Hreset	:1;
	uchar	WBAmode	:1;
	uchar	Awrap	:1;
	uchar	Reserved:1;
	uchar	CB2		:1;
	uchar	HRselect:1;
	uchar	RA1rMA14:1;
	uchar	RA0rMA13:1;
} CR17;

//18h	Line Compare
typedef struct {
	uint8	Lcompare70;
} CR18;

// 19h - 21h

//22h	Graphics Data Latch Read-back Register
typedef struct {
	uint8	GDlatch;
} CR22;

// 23h - unused

//24h	Attribute Controller Toggle Read-back Register
typedef struct {
	uchar	ACtoggle	:1;
	uchar	Reserved	:7;
} CR24;

// 25h - unused

//26h	Attribute Controller Index Read-back Register
typedef struct {
	uchar	Reserved	:2;
	uchar	Venable		:1;
	uchar	ACindex84	:5;
} CR26;

//
//19h	Extended Signature Read-Back Register 0
typedef struct {
	uint8	SRBR70;
} CR19;

//1Ah	Extended Signature Read-Back Register 1
typedef struct {
	uint8	SRBR158;
} CR1A;

//1Bh	CRT horizontal counter read-back
typedef struct {
	uint8	CRTHcounter70;
} CR1B;

//1Ch	CRT vertical counter read back
typedef struct {
	uint8	CRTVcounter70;
} CR1C;

//1Dh	CRT overflow counter read back
typedef struct {
	uchar	Reserved1		:3;
	uchar	CRTHcounter8	:1;
	uchar	Reserved2		:1;
	uchar	CRTVcounter108	:3;
} CR1D;

//1Eh	Extended Signature Read-Back Register 2
typedef struct {
	uint8	SRBR2316;
} CR1E;

// 1Fh - unused (reserved?)
typedef struct {
	uint8	Reserved;
} CRunused;

//20h  CRT Counter Trigger Port
typedef	struct {
	uint8	Reserved;
} CR20;

// 21h - unused

//
typedef union _uCRTC {
	struct {
		CR0		fCR0;
		CR1		fCR1;
		CR2		fCR2;
		CR3		fCR3;
		CR4		fCR4;
		CR5		fCR5;
		CR6		fCR6;
		CR7		fCR7;
		CR8		fCR8;
		CR9		fCR9;
		CRA		fCRA;
		CRB		fCRB;
		CRC		fCRC;
		CRD		fCRD;
		CRE		fCRE;
		CRF		fCRF;
		CR10	fCR10;
		CR11	fCR11;
		CR12	fCR12;
		CR13	fCR13;
		CR14	fCR14;
		CR15	fCR15;
		CR16	fCR16;
		CR17	fCR17;
		CR18	fCR18;
		CR19	fCR19;
		CR1A	fCR1A;
		CR1B	fCR1B;
		CR1C	fCR1C;
		CR1D	fCR1D;
		CR1E	fCR1E;
		CRunused	fCR1F;
		CR20		fCR20;
		CRunused	fCR21;
		CR22		fCR22;
		CRunused	fCR23;
		CR24		fCR24;
		CRunused	fCR25;
		CR26		fCR26;
	} s;
	uint8	fValue[39];
} uCRTC;

#endif