//
// uSEQR.h
//

//00	Reset Register

typedef struct {
	uchar	Areset		:1;
	uchar	Sreset		:1;
	uchar	Reserved	:6;
} SR0;

//01	Clock Mode

typedef struct {
	uchar	DC89		:1;
	uchar	Reserved2	:1;
	uchar	SL16enable	:1;
	uchar	DCD2enable	:1;
	uchar	SL32enable	:1;
	uchar	Soff		:1;
	uchar	Reserved1	:2;
} SR1;

//02	Color Plane Write Enable

typedef struct {
	uchar	P0Wenable	:1;
	uchar	P1Wenable	:1;
	uchar	P2Wenable	:1;
	uchar	P3Wenable	:1;
	uchar	Reserved	:4;
} SR2;

//03	Character Generator Select

typedef struct {
	uchar	CGTAselect10:2;
	uchar	CGTBselect10:2;
	uchar	CGTAselect2	:1;
	uchar	CGTBselect2	:1;
	uchar	Reserved	:2;
} SR3;

//04	Memory Mode

typedef struct {
	uchar	Reserved2	:1;
	uchar	Ememory		:1;
	uchar	OEMenable	:1;
	uchar	C4Menable	:1;
	uchar	Reserved1	:4;
} SR4;

// SiS extended registers
//05h	Extended Password/Identification Register
typedef struct {
	//D[7:0]	Password/Identification Bit[7:0]
	uint8	Pidentification;
} SR5;

//06h	Extended Graphics Mode Control Register
typedef struct {
	//D0	Enhanced text mode enable 
	//0:  Disable
	//1:  Enable
	uchar	ETMenable		:1;

	//D1	Enhanced graphics mode enable 
	//0:  Disable
	//1:  Enable
	uchar	EGMenable		:1;

	//D2	32K?Color graphics mode enable 
	//0:  Disable
	//1:  Enable
	uchar	C32KGMenable	:1;

	//D3	64K?Color graphics mode enable 
	//0:  Disable
	//1:  Enable
	uchar	C64KGMenable	:1;

	//D4	True?Color graphics mode enable 
	//0:  Disable
	//1:  Enable
	uchar	TCGMenable		:1;

	//D5	Graphics mode interlaced enable 
	//0:  Disable
	//1:  Enable
	uchar	GMIenable		:1;

	//D6	Graphics mode hardware cursor display enable 
	//0:  Disable
	//1:  Enable
	uchar	GMHCDenable		:1;

	//D7	Graphics mode linear addressing enable
	//0:  Disable
	//1:  Enable
	uchar	GMLAenable		:1;
} SR6;

//07h	Extended Misc. Control Register 0
typedef struct {
	//D0	External DAC reference voltage input
	//0:  Internal DAC reference voltage
	//1:  External DAC reference voltage
	//To achieve more accurate reference voltage. The reference voltage of DAC can be input from external.
	uchar	EDRVinput		:1;

	//D1	High Speed DAC operation
	//0:  Low speed
	//1:  High Speed
	//This bit should be set when DCLK frequency is greater than 135MHz
	uchar	HSDoperation	:1;

	//D2	24-bit color palette enable for direct color mode
	//0:  Enable
	//1:  Disable
	uchar	CP24fDCmode		:1;

	//D3	Enable multi-line pre-fetch
	//0:  Enable
	//1:  Disable
	uchar	EMLprefetch		:1;

	//D4	Extended video clock frequency divided by 2
	//0:  Disable
	//1:  Enable
	uchar	EVCFD2			:1;

	//D5	Internal RAMDAC power saving mode
	//0:  Power saving mode
	//1:  High power mode 
	uchar	IRPSmode		:1;

	//D6	Enable feature connector (VIDEO 0-7, PCLK) output
	//0:  Disable
	//1:  Enable
	uchar	EFCoutput		:1;

	//D7	Merge video line buffer into CRT FIFO
	//0:  Disable
	//1:  Enable
	//The size of CRT FIFO can be set to 256x64 bit when merged with video line buffer only when video playback is disabled.
	uchar	MVLBiCfifo		:1;
} SR7;

//08h	Extended CRT/CPU Threshold Control Register 0
typedef struct {
	//D[3:0]	CRT/Engine Threshold High Bit[3:0]
	uchar	CEThigh			:4;
	//D[7:4]	CRT/CPU Arbitration Threshold Low Bit[3:0]
	uchar	CCATlow			:4;
} SR8;

//09h	Extended CRT/CPU Threshold Control Register 1
typedef struct {
	//D[3:0]	CRT/CPU Threshold High Bit[3:0]
	uchar	CCThigh			:4;
	//D[7:4]	ASCII/Attribute Threshold Bit[3:0]
	uchar	AAthreshold		:4;
} SR9;

//0Ah	Extended CRT Overflow Register
typedef struct {
	//D0	Extended Vertical Total Bit[10]
	uchar	EVtotal10		:1;
	//D1	Extended Vertical Display Enable End Bit[10]
	uchar	EVDEend10		:1;
	//D2	Extended Vertical Blank Start Bit[10]
	uchar	EVBstart10		:1;
	//D3	Extended Vertical Retrace Start Bit[10]
	uchar	EVRstart10		:1;
	//D[7:4]	Extended Screen Offset Bit[11:8]
	uchar	ESoffset118		:4;
} SRA;

//0Bh	Extended Misc. Control Register 1
typedef struct {
	//D0	CPU-driven BITBLT operation enable
	//0:  Disable
	//1:  Enable
	uchar	CdBOenable		:1;

	//D1	16-color packed pixel enable
	//0:  Disable
	//1:  Enable
	uchar	C16PPenable		:1;

	//D2	I/O gating enable while write-buffer is not empty
	//0:  Disable
	//1:  Enable
	uchar	IOGenable		:1;

	//D3	Dual segment register mode enable
	//0:  Disable
	//1:  Enable
	uchar	DSRMenable		:1;

	//D4	True-Color frame rate modulation enable
	//0:  Disable
	//1:  Enable
	uchar	TCFRMenable		:1;

	//D[6:5]	Memory-mapped I/O Space Selection Bit[1:0]
	//00:  Disable
	//01:  Select Axxxxh as Memory-mapped I/O Space
	//10:  Select Bxxxxh as Memory-mapped I/O Space
	//11:  Select PCI config register 14H as Memory-mapped I/O space
	uchar	MMIOSselection	:2;

	//D7 	True-Color Graphics mode RGB Sequence Selection
	//0:  Red, Green, and Blue in byte order
	//1:  Blue, Green, and Red in byte order
	uchar	TCGMRGBSselection	:1;
} SRB;

//0Ch	Extended Misc. Control Register 2
typedef struct {
	//D0	Synchronous reset timing generator enable
	//0:  Disable
	//1:  Enable
	uchar	SRTGenable	:1;

	//D[2:1]	Memory Configuration Bit[1:0]
	//00:  1MByte/1 bank
	//01:  2MByte/2 banks
	//10:  4MByte/2 banks or 4 banks
	//11:  1MByte/2 banks
	uchar	Mconfiguration	:2;

	//D3	Test mode enable
	//0:  Disable
	//1:  Enable
	uchar	TMenable		:1;

	//D4	Reserved
	uchar	Mconf2		:1;

	//D5	Read-ahead cache operation enable
	//0:  Disable
	//1:  Enable
	uchar	RACOenable		:1;

	//D6	Text mode 16?bit memory access enable
	//0:  Disable
	//1:  Enable
	uchar	TM16MAenable	:1;

	//D7	Graphics mode 32?bit memory access enable
	//0:  Disable
	//1:  Enable
	uchar	GM32MAenable	:1;
} SRC;

//0Dh	Extended Configuration Status 0
typedef struct {
	//D0	Select I/O address 3C3h or 46E8h as video subsystem port
	//0:  Select 3C3h
	//1:  Select 46E8h when MD16 is pulled up with resistor
	uchar	SIO3C3o46E8		:1;

	//D1	Video subsystem enable/disable at power-on is
	//0:  Controlled by System BIOS
	//1:  Forced to disable when MD17 is pulled up with resistor.
	uchar	VSED			:1;

	//D2	NTSC/PAL select
	//0:  NTSC
	//1:  PAL when MD18 is pulled up with resistor
	uchar	NPselect		:1;

	//D3	Reserved  (i.e.  MD19 is reserved.)
	uchar	Reserved		:1;

	//D4	AGP bus enable
	//0:  Disable
	//1:  Enable AGP bus when MD20 is pulled up with resistor.
	uchar	AGPenable		:1;

	//D5	AGP 2X Transfer Mode enable
	//0:  Disable
	//1:  Enable AGP 2X Transfer Mode when MD21 is pulled up with resistor.
	uchar	AGP2Xenable		:1;

	//D6	Clock Generator Selection
	//0:  Select internal clock generator
	//1:  Select external clock generator (used for SiS internal test only) when MD22 is pulled up with resistor
	uchar	CGselection		:1;

	//D7	Enable 64K ROM decoding
	//0:  Disable
	//1:  Enable when MD23 is pulled up with resistor.
	uchar	E64KRdecoding	:1;
} SRD;

//0Eh	Extended Configuration Status 1
typedef struct {
	//D[1:0]	Reserved  (i.e.  MD[25:24] are reserved.)
	uchar	Reserved		:2;

	//D2	BIOS ROM decoding logic
	//0:  Enable
	//1:  Disable when MD26 is pulled up with resistor.
	uchar	BRDlogic		:1;

	//D3	INTA# Selection
	//0:  Disable
	//1:  Enable when MD27 is pulled up with resistor
	uchar	INTAselection	:1;

	//D4	Enable VMI Interface
	//0:  Enable
	//1:  Disable when MD28 is pulled up with resistor.
	uchar	EVinterface		:1;

	//D[7:5]	DRAM speed setting bit[2:0]
	//0:  MD[31:29] not pulled-up with resistors  
	//1:  MD[31:29] pulled-up with resistors  
	uchar	DSsetting		:3;

} SRE;

//0Fh	Extended Scratch Register 0
typedef struct {
	//D[7:0]	Reserved for video BIOS
	uint8	ESR0;
} SRF;

//10h	Extended Scratch Register 1
typedef struct {
	//D[7:0]	Reserved for video BIOS
	uint8	ESR1;
} SR10;

//11h	Extended DDC and Power Control Register
typedef struct {
	//D0	DDC CLK Programming
	//While writing this bit, 
	//0:  Output '0' logic into DDC Clock Signal.
	//1:  Output '1' logic into DDC Clock Signal.
	//While reading this bit, 
	//0:  Get '0' logic from DDC Clock Signal .
	//1:  Get '1' logic from DDC Clock Signal .
	uchar	DCprogramming	:1;

	//D1	DDC DATA Programming
	//While writing this bit, 
	//0:  Output '0' logic into DDC Data Signal.
	//1:  Output '1' logic into DDC Data Signal.
	//While reading this bit, 
	//0:  Get '0' logic from DDC Data Signal .
	//1:  Get '1' logic from DDC Data Signal .
	uchar	DDprogramming	:1;

	//D[3:2]	Reserved
	uchar	Reserved		:2;

	//D4	Enable keyboard and hardware cursor as system activation source
	//0:  Disable
	//1:  Enable
	uchar	EKHCactivation	:1;

	//D5	Enable video memory access as activation source
	//0:  Disable
	//1:  Enable
	uchar	EVMAactivation	:1;

	//D6	Force VGA into standby mode
	//0:  Disable
	//1:  Enable
	uchar	FVstandby		:1;

	//D7	Force VGA into suspend mode
	//0:  Disable
	//1:  Enable
	uchar	FVsuspend		:1;
} SR11;

//12h	Extended Horizontal Overflow Register
typedef struct {
	//D0	Extended Horizontal Total Bit[8]
	uchar	EHtotal8		:1;

	//D1	Extended Horizontal Display Enable End Bit[8]
	uchar	EHDEend8		:1;

	//D2	Extended Horizontal Blank Start Bit[8]
	uchar	EHBstart8		:1;

	//D3	Extended Horizontal Retrace Start Bit[8]
	uchar	EHRstart8		:1;

	//D4	Extended Horizontal Blank End Bit[6]
	uchar	EHBend6			:1;

	//D[7:5]	Horizontal Retrace Skew
	//000 : no delay
	//001 : delay 1 DCLK
	//010 : delay 2 DCLK
	//011 : delay 3 DCLK
	//100 : delay 4 DCLK
	//101 : delay 5 DCLK
	//110 : delay 6 DCLK
	//111 : delay 7 DCLK
	uchar	HRskew			:3;
} SR12;

//13h	25/28/Internal Extended Clock Generator Register
typedef struct {
	//D[5:0]	Reserved
	uchar	Reserved	:6;

	//D6	25/28/Internal VCLK Post-Scale Bit[2]
	uchar	IVPscale	:1;

	//D7	MCLK Post-scale Bit[2]
	uchar	MPscale		:1;
} SR13;

//14h	Extended Hardware Cursor Color 0 Red Register
typedef struct {
	//D[5:0]	Hardware Cursor Color 0 Red Bit[5:0]
	uchar	HCC0red		:6;
	//D[7:6]	Reserved
	uchar	Reserved	:2;
} SR14;

//15h	Extended Hardware Cursor Color 0 Green Register
typedef struct {
	//D[5:0]	Hardware Cursor Color 0 Green Bit[5:0]
	uchar	HCC0green	:6;
	//D[7:6]	Reserved
	uchar	Reserved	:2;
} SR15;

//16h	Extended Hardware Cursor Color 0 Blue Register
typedef struct {
	//D[5:0]	Hardware Cursor Color 0 Blue Bit[5:0]
	uchar	HCC0blue	:6;
	//D[7:6]	Reserved
	uchar	Reserved	:2;
} SR16;

//17h	Extended Hardware Cursor Color 1 Red Register
typedef struct {
	//D[5:0]	Hardware Cursor Color 1 Red Bit[5:0]
	uchar	HCC1red		:6;
	//D[7:6]	Reserved
	uchar	Reserved	:2;
} SR17;

//18h	Extended Hardware Cursor Color 1 Green Register
typedef struct {
	//D[5:0]	Hardware Cursor Color 1 Green Bit[5:0]
	uchar	HCC1green	:6;
	//D[7:6]	Reserved
	uchar	Reserved	:2;
} SR18;

//19h	Extended Hardware Cursor Color 1 Blue Register
typedef struct {
	//D[5:0]	Hardware Cursor Color 1 Blue Bit[5:0]
	uchar	HCC1blue	:6;
	//D[7:6]	Reserved
	uchar	Reserved	:2;
} SR19;

//1Ah	Extended Hardware Cursor Horizontal Start Register 0
typedef struct {
	//D[7:0]	Hardware Cursor Horizontal Start Bit[7:0]
	uint8	HCHstart70;
} SR1A;

//1Bh	Extended Hardware Cursor Horizontal Start Register 1
typedef struct {
	//D[2:0]	Hardware Cursor Horizontal Start Bit[10:8]
	uchar	HCHstart108		:3;
	//D[7:3]	Reserved
	uchar	Reserved		:5;
} SR1B;

//1Ch	Extended Hardware Cursor Horizontal Preset Register
typedef struct {
	//D[5:0]	Hardware Cursor Horizontal Preset Bit[5:0]
	uchar	HCHpreset		:6;
	//D[7:6]	Reserved
	uchar	Reserved		:2;
} SR1C;

//1Dh	Extended Hardware Cursor Vertical Start Register 0
typedef struct {
	//D[7:0]	Hardware Cursor Vertical Start Bit[7:0]
	uint8	HCVstart70;
} SR1D;

//1Eh	Extended Hardware Cursor Vertical Start Register 1
typedef struct {
	//D[2:0]	Hardware Cursor Vertical Start Bit[10:8]
	uchar	HCVstart108		:3;

	//D3	Hardware Cursor Side Pattern Enable
	//0:  Disable
	//1:  Enable
	uchar	HCSPenable		:1;

	//D[7:4]	Hardware Cursor Pattern Select Bit[3:0]
	uchar	HCPselect		:4;
} SR1E;

//1Fh	Extended Hardware Cursor Vertical Preset Register
typedef struct {
	//D[5:0]	Hardware Cursor Vertical Preset Bit[5:0]
	uchar	HCVpreset		:6;
	//D[7:6]	Reserved
	uchar	Reserved		:2;
} SR1F;

//20h	Extended Linear Addressing Base Address Register 0
typedef struct {
	//D[7:0]	Linear Addressing Base Address Bit[26:19]
	uint8	LABaddress2619;
} SR20;

//21h	Extended Linear Addressing Base Address Register 1
typedef struct {
	//D[4:0]	Linear Addressing Base Address Bit[31:27]
	uchar	LABaddress3127	:5;
	//D[7:5]	Linear Addressing Space Aperture Bit[2:0]
	//000:  512 Kbyte
	//001:  1 Mbyte
	//010:  2 Mbyte
	//011:  4 MByte
	//100:  4 MByte
	//Other:  Reserved
	uchar	LASaperture		:3;
} SR21;

//22h	Extended Standby/Suspend Timer Register
typedef struct {
	//D[3:0]	Standby Timer Bit[3:0]
	//The resolution for Standby Timer is 2 minutes.
	uchar	StandbyTimer	:4;
	//D[7:4]	Suspend Timer Bit[3:0]
	//The resolution for Suspend Timer is 2 minutes.
	uchar	SuspendTimer	:4;
} SR22;

//23h	Extended Misc. Control Register 3
typedef struct {
	//D[2:0]	DRAM Control Signal Delay Compensation Bit[1:0]
	//000:  Delay 4 ns
	//001:  Delay 5 ns
	//010:  Delay 6 ns
	//011:  Delay 7 ns
	//100:  Delay 8 ns
	//101:  Delay 9 ns
	//110:  Delay 10 ns
	//111:  Delay 11 ns
	uchar	DCSDcompensation	:3;

	//D3	Video Compatible Hardware Cursor Visibility Enable
	//0:  Disable
	//1:  Enable
	uchar	VCHCVenable			:1;

	//D4	Bypass SRAM
	//0:  Disable
	//1:  Enable
	uchar	Bsram				:1;

	//D5	EDO DRAM Enable Bit
	//0:  Disable
	//1:  Enable
	uchar	EDOenable			:1;

	//D6	CRC Generator Enable
	//0:  Disable
	//1:  Enable
	uchar	CRCGenable			:1;

	//D7	Reserved
	uchar	Reserved			:1;
} SR23;

//24h	Extended Reserved Register
typedef struct {
	uint8	Reserved;
} SR24;

//25h	Extended Scratch Register 2
typedef struct {
	uint8	Reserved;
} SR25;

//26h	Extended Graphics Engine Register 0
typedef struct {
	//D0	Reserved
	uchar	Reserved0		:1;

	//D1	Slow FP/EDO DRAM RAS* to CAS* Timing enable
	//0:  Disable (7 MCLK/DRAM cycle)
	//1:  Enable (8 MCLK/DRAM cycle)
	uchar	SFEDR2CTenable	:1;

	//D2	Slow DRAM RAS pre-charge time
	//0:  Disable (3 MCLK/DRAM cycle)
	//1:  Enable (4 MCLK/DRAM cycle)
	uchar	SDRPtime		:1;

	//D3	Reserved
	uchar	Reserved3		:1;

	//D4	Continuous Memory Data Access Enable Bit
	//0:  Disable
	//1:  Enable
	uchar	CMDAenable		:1;

	//D5	PCI Burst-Write Mode enable 
	//0:  Disable
	//1:  Enable
	uchar	PBMenable		:1;

	//D6	Power-down Internal RAMDAC
	//0:  Disable
	//1:  Enable
	uchar	PDIramdac		:1;

	//D7	Reserved
	uchar	Reserved7		:1;
} SR26;

//27h	Extended Graphics Engine Register 1
typedef struct {
	//D[3:0]	Extended Screen Start Address Bit[19:16]
	uchar	ESSaddress1916	:4;

	//D[5:4]	Logical Screen Width and Byte-Per-Pixel Select Bit[1:0]
	//00	1024, 256 colors or 512, 32k/64k colors
	//01	2048, 256 colors or 1024, 32k/64k colors
	//10	4096, 256 colors or 2048, 32k/64k colors
	//11	invalid
	uchar	LSWaBselect		:2;

	//D6	Graphics Engine Register Programming enable
	//0:  Disable
	//1:  Enable
	uchar	GERPenable		:1;

	//D7	Turbo Queue Engine enable
	//0:  Disable
	//1:  Enable
	uchar	TQEenable		:1;
} SR27;

//28h	Extended Internal Memory Clock Register 0
typedef struct {
	//D[6:0]	MCLK Numerator Bit[6:0]
	//[0000000:1111111] = [1:128]
	uchar	Mnumerator		:7;

	//D[7]	MCLK Divider 
	//0:  Do not divide
	//1:  Divide by 2
	uchar	Mdivider		:1;
} SR28;

//29h	Extended Internal Memory Clock Register 1
typedef struct {
	//D[4:0]	MCLK DeNumerator Bit[4:0]
	//[00000:11111] = [1:32]
	uchar	Mdenumrator	:5;

	//D[6:5]	MCLK Post-Scale Bit[1:0]
	//When SR13 D6=0 (refer to "7.7.16" on page 90),  
	//00:  Do not scale
	//01:  Scaled by 2
	//10:  Scaled by 3
	//11:  Scaled by 4
	//When SR13 D6=1 (refer to "7.7.16" on page 90),  
	//00:  Reserved
	//01:  Reserved
	//10:  Scaled by 6
	//11:  Scaled by 8
	uchar	MPscale		:2;

	//D7	MCLK VCO Gain
	//0:  Gain for low frequency operation
	//1: Gain for high frequency operation
	uchar	MVgain		:1;
} SR29;

//2Ah	Extended Internal Video Clock Register 0/Extended 25Mhz Video Clock Register 0/Extended 28Mhz Video Clock Register 0
typedef struct {
	//D[6:0]	25/28/Internal VCLK Numerator Bit[6:0]
	//[0000000:1111111] = [1:128]
	uchar	IVnumerator		:7;

	//D[7]	25/28/Internal VCLK Divider 
	//0:  Do not divide
	//1:  Divide by 2
	uchar	IVdivider		:1;
} SR2A;

//2Bh	Extended Internal Video Clock Register 1/Extended 25Mhz Video Clock Register 1/Extended 28Mhz Video Clock Register 1
typedef struct {
	//D[4:0]	25/28/Internal VCLK DeNumerator Bit[4:0]
	//[00000:11111] = [1:32]
	uchar	IVdenumerator	:5;

	//D[6:5]	25/28/Internal VCLK Post-Scale Bit[1:0]
	//When SR13 D7 = 0 (refer to "7.7.16" on page 90),  
	//00:  Do not scale
	//01:  Scaled by 2
	//10:  Scaled by 3
	//11:  Scaled by 4
	//When SR13 D7 = 1 (refer to "7.7.16" on page 90),  
	//00:  Reserved
	//01:  Reserved
	//10:  Scaled by 6
	//11:  Scaled by 8
	uchar	IVPscale		:2;

	//D7	25/28/Internal VCLK VCO Gain 
	//0:  Gain for low frequency operation
	//1:  Gain for high frequency operation
	uchar	IVVgain			:1;
} SR2B;

//2Ch	Extended Turbo Queue Base Address
typedef struct {
	//D[6:0]	Turbo Queue Base Address Bit[6:0]
	uchar	TQBaddress		:7;
	//D7	Reserved
	uchar	Reserved		:1;
} SR2C;

//2Dh	Extended Memory Start Control Register
typedef struct {
	//D[3:0]	Page Size Select
	//0000:  2 KB at 32-bit mode, 4 KB at 64-bit mode
	//0001:  4 KB at 32-bit mode, 8 KB at 64-bit mode
	//0010:  8 KB at 32-bit mode, 16 KB at 64-bit mode
	//0011:  16 KB at 32-bit mode, 32 KB at 64-bit mode
	//0100:  1 KB at 32-bit mode, 2 KB at 64-bit mode
	//Others:  Reserved
	uchar	PSselect	:4;
	//D[7:4]	Reserved
	uchar	Reserved	:4;
} SR2D;

//2Eh	Extended Reserved Register
typedef struct {
	uint8	Reserved;
} SR2E;

//2Fh	Extended DRAM Frame Buffer Size Register
typedef struct {
	//D[3:0]	Reserved
	uchar	Reserved30	:4;

	//D4	Enable Fast Page Flip
	//0:  Disable
	//1:  Enable
	uchar	EFPflip		:1;

	//D5	Enable Fast Change Mode Timing
	//0:  Disable
	//1:  Enable
	uchar	EFCMtiming	:1;

	//D[7:6]	Reserved
	uchar	Reserved76	:2;
} SR2F;

//30h	Extended Fast Page Flip Starting Address Low Register
typedef struct {
	//D[7:0]	Fast page flip starting address bit[7:0]
	uint8	FPFSaddress70;
} SR30;

//31h	Extended Fast Page Flip Starting Address Middle Register 
typedef struct {
	//D[7:0]	Fast page flip start address bit[15:8]
	uint8	FPFSaddress158;
} SR31;

//32h	Extended Fast Page Flip Starting Address High Register 
typedef struct {
	//D[3:0]	Fast page flip start address bit[19:16]
	uchar	FPFSaddress1916	:4;
	//D[7:4]	Reserved
	uchar	Reserved		:4;
} SR32;

//33h	Extended Misc. Control Register 4
typedef struct {
	//D0	Enable SGRAM timing
	//0:  Disable
	//1:  Enable
	uchar	EStiming	:1;
	//D1	Enable SGRAM Mode Write timing
	//0:  Disable
	//1:  Enable
	//This bit must be set before accessing SGRAM.  It must clear to 0 before setting to 1 to generate a new Mode Write cycle. 
	uchar	ESMWtiming	:1;

	//D2	Select SGRAM Latency
	//0:  Latency = 3
	//1:  Latency = 2
	uchar	SGlatency	:1;

	//D3	Enable one cycle EDO DRAM timing
	//0:  Disable
	//1:  Enable
	uchar	EPCEDtiming	:1;

	//D4	Standard VGA I/O port addresses decoding enable
	//0:  Enable
	//1:  Disable
	//The standard VGA register I/O port address decoding can be disabled by this bit.
	uchar	SVGAIODdisable	:1;

	//D5	Relocated VGA I/O port addresses decoding disable
	//0:  Disable
	//1:  Enable
	//The standard VGA register I/O port address can be relocated to address defined by PCI Config Register 18H.  This bit disable the relocated address decoding.
	uchar	RVGAIODenable	:1;

	//D6	Select external TVCLK as MCLK enable
	//0:  Disable
	//1:  Enable
	uchar	SETMenable		:1;

	//D7	Reserved
	uchar	Reserved		:1;
} SR33;

//34h	Extended Misc. Control Register 5
typedef struct {
	//D0	Enable Hardware Command Queue threshold low
	//0:  Disable
	//1:  Enable
	uchar	EHCQTlow		:1;

	//D1	Reserved
	uchar	Reserved1		:1;

	//D2	Enable DRAM output PAD low power consumption
	//0:  Disable
	//1:  Enable
	uchar	EDOPLPcomsumption	:1;

	//D[5:3]	Reserved
	uchar	Reserved53		:3;

	//D6	DRAM controller one cycle read enable
	//0:  Enable
	//1:  Disable
	uchar	DCOCRenable		:1;

	//D7	DRAM controller one cycle write enable
	//0:  Disable
	//1:  Enable
	uchar	DCOCWenable		:1;
} SR34;

//35h	Extended Misc. Control Register 6
typedef struct {
	//D0	Enable PCI Bus Read Cycle Retry
	//0:  Disable
	//1:  Enable
	uchar	EPBRCretry		:1;

	//D1	Enable PCI Bus Write Cycle Retry
	//0:  Disable
	//1:  Enable
	uchar	EPBWCretry		:1;

	//D[3:2]	DRAM CAS LOW period width compensation bit[1:0]
	//00:  Add 0ns
	//01:  Add 2ns
	//10:  Add 4ns
	//11:  Add 6ns
	uchar	DCLPWcompensation	:2;

	//D4	Enable PCI burst write zero-wait
	//0:  Disable
	//1:  Enable
	uchar	EPBWzerowait		:1;

	//D5	SGRAM burst timing enable
	//0:  Enable
	//1:  Disable
	uchar	SBTenable			:1;

	//D6	MA delay compensation
	//0:  Add 0ns
	//1:  Add 2ns
	uchar	MDcompensation		:1;

	//D7	Enable Hardware MPEG
	//0:  Disable
	//1:  Enable
	uchar	EHMPEG				:1;

} SR35;

//36h	Extended Scratch Register 3
typedef struct {
	uint8	Reserved;
} SR36;

//37h	Extended Scratch Register 4
typedef struct {
	uint8	Reserved;
} SR37;

//38h	Extended Misc. Control Register 7
typedef struct {
	//D[1:0]	Video Clock Register Selection Bit[1:0]
	//00 : Select Internal Video Clock Registers
	//	SR13, SR2A, SR2B
	//01 : Select 25MHz Video Clock Registers
	//	SR13, SR2A-1, SR2B-1
	//10 : Select 28MHz Video Clock Registers
	//	SR13, SR2A-2, SR2B-2
	//11 : Reserved
	//	There are three video clock registers Internal Video Clock Registers,
	//	25Mhz Video Clock Registers, 28Mhz Video Clock Registers.
	//	All three registers use the same index of 3C5, index 13,
	//	2A and 2B. The selection is programmed by Video Clock Register Selection Bit[1:0].
	//	The VCLK frequency is generated from Internal Video Clock Registers when
	//	Miscellaneous Output Register (port 3C2) Bit[3:0]=11.
	//	The VCLK frequency is generated from 25Mhz Video Clock Registers
	//	when Miscellaneous Output Register (port 3C2) bit[3:0]=00.
	//	The VCLK frequency is generated from 28Mhz Video Clock Registers
	//	when Miscellaneous Output Register (port 3C2) bit[3:0]=01.
	uchar	VCRselection	:2;

	//D2	Disable Line compare
	//0:  Enable
	//1:  Disable
	uchar	DLcompare		:1;

	//D3	Reserved
	uchar	Reserved		:1;

	//D[7:4]	Hardware Cursor Location
	//Hardware Cursor Starting Address Bit[21:18]
	uchar	HClocation		:4;
} SR38;

//39h	Extended Misc. Control Register 8
typedef struct {
	//D0	Enable MPEG II video decoding mode
	//0:  Disable
	//1:  Enable
	uchar	EMPEG2VDmode	:1;

	//D1	MPEG IDCT command software compression mode
	//0:  Disable
	//1:  Enable
	uchar	MICSCmode		:1;

	//D2	Enable 3D Accelerator
	//0:  Disable
	//1:  Enable
	uchar	E3Daccelerator	:1;

	//D3	Select external REFCLK as internal TVCLK enable
	//0:  Disable
	//1:  Enable
	uchar	SERAITenable	:1;

	//D4	Select external TVCLK as internal TVCLK enable
	//0:  Disable
	//1:  Enable
	uchar	SETAITenable	:1;

	//D[7:5]	Reserved 
	uchar	Reserved		:3;
} SR39;

//3Ah	Extended MPEG Turbo Queue Base Address
typedef struct {
	//D[6:0]	MPEG Turbo Queue Base Address Bit[6:0]
	uchar	MTQBaddress60	:7;
	//D7	Reserved
	uchar	Reserved		:1;
} SR3A;

//3Bh	Extended Clock Generator Control Register
typedef struct {
	//D[3:0]	Memory clock generator control bit[3:0]
	uchar	MCGcontrol		:4;
	//D[7:4]	Video clock generator control bit[3:0]
	uchar	VCGcontrol		:4;
} SR3B;

//3Ch	Extended Misc. Control Register 9
typedef struct {
	//D[1:0]	Turbo Queue length 2D/3D configuration bit[1:0]
	//00:  2D = 32KB, 3D = 0KB.
	//01:  2D = 16KB, 3D = 16KB.
	//10:  2D = 8KB, 3D = 24KB.
	//11:  2D = 4KB, 3D = 28KB.
	uchar	TQL2D3Dconfiguration	:2;

	//D2	PCI-66 MHz timing enable
	//0:  Disable
	//1:  Enable
	uchar	P66Tenable				:1;

	//D3	Enable AGP Dynamic Power Saving
	//0:  Disable
	//1:  Enable
	uchar	EADPsaving				:1;

	//D4	Enable Oscillator I/O PAD Power Down
	//0:  Enable
	//1:  Disable
	uchar	EOIOPPdown				:1;

	//D5	AGP request high priority enable
	//0:  Select low priority
	//1:  Select high priority
	uchar	ARHPenable				:1;

	//D6	SCLK output enable
	//0:  Enable
	//1:  Disable
	uchar	SOenable				:1;

	//D7	Reserved
	uchar	Reserved				:1;
} SR3C;

//3Dh
typedef struct {
	//D[0:4]
	uchar	Reserved1		:5;
	
	//D5
	uchar	Mconf3		:1;
	
	//D[7:6]
	uchar	Reserved2		:2;
} SR3D;

//3Eh
typedef struct {
	//D[0:3]
	uchar	Reserved1		:4;
	
	//D4
	uchar	SS816			:1;
	
	//D[7:5]
	uchar	Reserved2		:3;
} SR3E;

typedef union _uSEQR {
	struct {
		// VGA base
		SR0	fSR0;
		SR1	fSR1;
		SR2	fSR2;
		SR3	fSR3;
		SR4	fSR4;

		// SiS Extended
		SR5	fSR5;
		SR6	fSR6;
		SR7	fSR7;
		SR8	fSR8;
		SR9	fSR9;
		SRA	fSRA;
		SRB	fSRB;
		SRC	fSRC;
		SRD	fSRD;
		SRE	fSRE;
		SRF	fSRF;
		SR10	fSR10;
		SR11	fSR11;
		SR12	fSR12;
		SR13	fSR13;
		SR14	fSR14;
		SR15	fSR15;
		SR16	fSR16;
		SR17	fSR17;
		SR18	fSR18;
		SR19	fSR19;
		SR1A	fSR1A;
		SR1B	fSR1B;
		SR1C	fSR1C;
		SR1D	fSR1D;
		SR1E	fSR1E;
		SR1F	fSR1F;
		SR20	fSR20;
		SR21	fSR21;
		SR22	fSR22;
		SR23	fSR23;
		SR24	fSR24;
		SR25	fSR25;
		SR26	fSR26;
		SR27	fSR27;
		SR28	fSR28;
		SR29	fSR29;
		SR2A	fSR2A;
		SR2B	fSR2B;
		SR2C	fSR2C;
		SR2D	fSR2D;
		SR2E	fSR2E;
		SR2F	fSR2F;
		SR30	fSR30;
		SR31	fSR31;
		SR32	fSR32;
		SR33	fSR33;
		SR34	fSR34;
		SR35	fSR35;
		SR36	fSR36;
		SR37	fSR37;
		SR38	fSR38;
		SR39	fSR39;
		SR3A	fSR3A;
		SR3B	fSR3B;
		SR3C	fSR3C;
		SR3D	fSR3D;
		SR3E	fSR3E;
	} s;
	uint8	fValue[63];
} uSEQR;

