#ifndef _CTEXT_VIEW_H_
#define _CTEXT_VIEW_H_


#include <TextView.h>


class CTextView : public BTextView
{
	public:
		CTextView(BRect a_frame,const char* a_name,int32 a_resize_mode,int32 a_flags);
		virtual ~CTextView();

		virtual void DetachedFromWindow();
		virtual void FrameResized(float a_width, float a_height);
		virtual void MakeFocus(bool a_focused);
		void SetText(const char *text, int32 length, const text_run_array *runs = NULL);
		void SetText(const char *text, const text_run_array *runs = NULL);
		void SetText(BFile *file, int32 offset, int32 length, const text_run_array *runs = NULL);
		virtual void StoreChange();
		virtual void Modified();
		bool HasBeenModified();
		void ResetTextRect();

	protected:
		virtual void InsertText(const char *a_text, int32 a_length, int32 a_offset, const text_run_array *a_runs);

	private:
		bool m_modified;
		bool m_modified_disabled;
};


#endif
